/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ChannelCredentials;
import io.grpc.Internal;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.XdsInitializationException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public interface Bootstrapper {
    public BootstrapInfo bootstrap() throws XdsInitializationException;

    @Internal
    public static class BootstrapInfo {
        private List<ServerInfo> servers;
        private final EnvoyProtoData.Node node;
        @Nullable
        private final Map<String, CertificateProviderInfo> certProviders;
        @Nullable
        private final String grpcServerResourceId;

        @VisibleForTesting
        BootstrapInfo(List<ServerInfo> servers, EnvoyProtoData.Node node, Map<String, CertificateProviderInfo> certProviders, String grpcServerResourceId) {
            this.servers = servers;
            this.node = node;
            this.certProviders = certProviders;
            this.grpcServerResourceId = grpcServerResourceId;
        }

        List<ServerInfo> getServers() {
            return Collections.unmodifiableList(this.servers);
        }

        public EnvoyProtoData.Node getNode() {
            return this.node;
        }

        public Map<String, CertificateProviderInfo> getCertProviders() {
            return Collections.unmodifiableMap(this.certProviders);
        }

        @Nullable
        public String getGrpcServerResourceId() {
            return this.grpcServerResourceId;
        }
    }

    @Internal
    public static class CertificateProviderInfo {
        private final String pluginName;
        private final Map<String, ?> config;

        CertificateProviderInfo(String pluginName, Map<String, ?> config) {
            this.pluginName = (String)Preconditions.checkNotNull((Object)pluginName, (Object)"pluginName");
            this.config = (Map)Preconditions.checkNotNull(config, (Object)"config");
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public Map<String, ?> getConfig() {
            return this.config;
        }
    }

    @Internal
    public static class ServerInfo {
        private final String target;
        private final ChannelCredentials channelCredentials;
        private final boolean useProtocolV3;

        @VisibleForTesting
        ServerInfo(String target, ChannelCredentials channelCredentials, boolean useProtocolV3) {
            this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
            this.channelCredentials = (ChannelCredentials)Preconditions.checkNotNull((Object)channelCredentials, (Object)"channelCredentials");
            this.useProtocolV3 = useProtocolV3;
        }

        String getTarget() {
            return this.target;
        }

        ChannelCredentials getChannelCredentials() {
            return this.channelCredentials;
        }

        boolean isUseProtocolV3() {
            return this.useProtocolV3;
        }
    }
}

