/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.Status;
import io.grpc.xds.AutoValue_HttpFault;
import io.grpc.xds.AutoValue_HttpFault_FaultAbort;
import io.grpc.xds.AutoValue_HttpFault_FaultDelay;
import io.grpc.xds.Matchers;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
abstract class HttpFault {
    HttpFault() {
    }

    @Nullable
    abstract FaultDelay faultDelay();

    @Nullable
    abstract FaultAbort faultAbort();

    abstract String upstreamCluster();

    abstract ImmutableList<String> downstreamNodes();

    abstract ImmutableList<Matchers.HeaderMatcher> headers();

    @Nullable
    abstract Integer maxActiveFaults();

    static HttpFault create(@Nullable FaultDelay faultDelay, @Nullable FaultAbort faultAbort, String upstreamCluster, List<String> downstreamNodes, List<Matchers.HeaderMatcher> headers, @Nullable Integer maxActiveFaults) {
        return new AutoValue_HttpFault(faultDelay, faultAbort, upstreamCluster, (ImmutableList<String>)ImmutableList.copyOf(downstreamNodes), (ImmutableList<Matchers.HeaderMatcher>)ImmutableList.copyOf(headers), maxActiveFaults);
    }

    @AutoValue
    static abstract class FaultAbort {
        FaultAbort() {
        }

        @Nullable
        abstract Status status();

        abstract boolean headerAbort();

        abstract int ratePerMillion();

        static FaultAbort forStatus(Status status, int ratePerMillion) {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            return FaultAbort.create(status, false, ratePerMillion);
        }

        static FaultAbort forHeader(int ratePerMillion) {
            return FaultAbort.create(null, true, ratePerMillion);
        }

        private static FaultAbort create(@Nullable Status status, boolean headerAbort, int ratePerMillion) {
            return new AutoValue_HttpFault_FaultAbort(status, headerAbort, ratePerMillion);
        }
    }

    @AutoValue
    static abstract class FaultDelay {
        FaultDelay() {
        }

        @Nullable
        abstract Long delayNanos();

        abstract boolean headerDelay();

        abstract int ratePerMillion();

        static FaultDelay forFixedDelay(long delayNanos, int ratePerMillion) {
            return FaultDelay.create(delayNanos, false, ratePerMillion);
        }

        static FaultDelay forHeader(int ratePerMillion) {
            return FaultDelay.create(null, true, ratePerMillion);
        }

        private static FaultDelay create(@Nullable Long delayNanos, boolean headerDelay, int ratePerMillion) {
            return new AutoValue_HttpFault_FaultDelay(delayNanos, headerDelay, ratePerMillion);
        }
    }
}

