/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Invokable {
    public static Invokable createInvokable(final Supplier<Object> getter) {
        return new Invokable(){

            @Override
            public Supplier<Object> getGetter() {
                return getter;
            }
        };
    }

    public static Invokable createInvokable(final Consumer<Object> setter) {
        return new Invokable(){

            @Override
            public Consumer<Object> getSetter() {
                return setter;
            }
        };
    }

    public static Invokable createInvokable(final Function<Object[], Object> function) {
        return new Invokable(){

            @Override
            public Function<Object[], Object> getOperation() {
                return function;
            }
        };
    }

    public static Invokable createSerializableInvokable(final Supplier<Object> getter) {
        return new SerializableInvokable(){
            private static final long serialVersionUID = 7967781506782273712L;

            @Override
            public Supplier<Object> getGetter() {
                return getter;
            }
        };
    }

    public static Invokable createSerializableInvokable(final Consumer<Object> setter) {
        return new SerializableInvokable(){
            private static final long serialVersionUID = 4827274105413710866L;

            @Override
            public Consumer<Object> getSetter() {
                return setter;
            }
        };
    }

    public static Invokable createSerializableInvokable(final Function<Object[], Object> function) {
        return new SerializableInvokable(){
            private static final long serialVersionUID = 2945328936175486929L;

            @Override
            public Function<Object[], Object> getOperation() {
                return function;
            }
        };
    }

    default public Supplier<Object> getGetter() {
        return null;
    }

    default public Consumer<Object> getSetter() {
        return null;
    }

    default public Function<Object[], Object> getOperation() {
        return null;
    }

    default public String getUrl() {
        return "";
    }

    default public String getSubmodelRepositoryUrl() {
        return "";
    }

    default public void execute(OperationInvocation invocation) throws IOException {
    }

    public static interface OperationInvocation {
    }

    public static interface SerializableInvokable
    extends Invokable,
    Serializable {
    }

    public static interface OperationInvokable
    extends Invokable,
    Function<Object[], Object> {
        @Override
        default public Function<Object[], Object> getOperation() {
            return this;
        }
    }

    public static interface SetterInvokable
    extends Invokable,
    Consumer<Object> {
        @Override
        default public Consumer<Object> getSetter() {
            return this;
        }
    }

    public static interface GetterInvokable
    extends Invokable,
    Supplier<Object> {
        @Override
        default public Supplier<Object> getGetter() {
            return this;
        }
    }
}

