/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.InternalConfigSelector;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.Matchers;
import io.grpc.xds.SharedCallCounterMap;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsNameResolverProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

final class XdsNameResolver
extends NameResolver {
    static final CallOptions.Key<String> CLUSTER_SELECTION_KEY = CallOptions.Key.create((String)"io.grpc.xds.CLUSTER_SELECTION_KEY");
    @VisibleForTesting
    static boolean enableTimeout = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_TIMEOUT"));
    private final XdsLogger logger;
    private final String authority;
    private final NameResolver.ServiceConfigParser serviceConfigParser;
    private final SynchronizationContext syncContext;
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;
    private final ThreadSafeRandom random;
    private final ConcurrentMap<String, AtomicInteger> clusterRefs = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConfigSelector configSelector = new ConfigSelector();
    private volatile RoutingConfig routingConfig = RoutingConfig.access$100();
    private NameResolver.Listener2 listener;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private XdsNameResolverProvider.CallCounterProvider callCounterProvider;
    private ResolveState resolveState;

    XdsNameResolver(String name, NameResolver.ServiceConfigParser serviceConfigParser, SynchronizationContext syncContext) {
        this(name, serviceConfigParser, syncContext, SharedXdsClientPoolProvider.getDefaultProvider(), ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    XdsNameResolver(String name, NameResolver.ServiceConfigParser serviceConfigParser, SynchronizationContext syncContext, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory, ThreadSafeRandom random) {
        this.authority = GrpcUtil.checkAuthority((String)((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
        this.serviceConfigParser = (NameResolver.ServiceConfigParser)Preconditions.checkNotNull((Object)serviceConfigParser, (Object)"serviceConfigParser");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolFactory");
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-resolver", (String)name));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created resolver for {0}", name);
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(NameResolver.Listener2 listener) {
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        try {
            this.xdsClientPool = this.xdsClientPoolFactory.getXdsClientPool();
        }
        catch (Exception e) {
            listener.onError(Status.UNAVAILABLE.withDescription("Failed to initialize xDS").withCause((Throwable)e));
            return;
        }
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        this.callCounterProvider = SharedCallCounterMap.getInstance();
        this.resolveState = new ResolveState();
        this.resolveState.start();
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.resolveState != null) {
            this.resolveState.stop();
        }
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    @VisibleForTesting
    static Map<String, ?> generateServiceConfigWithMethodTimeoutConfig(long timeoutNano) {
        String timeout = (double)timeoutNano / 1.0E9 + "s";
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put("name", Collections.singletonList(Collections.emptyMap()));
        methodConfig.put("timeout", timeout);
        return Collections.singletonMap("methodConfig", Collections.singletonList(Collections.unmodifiableMap(methodConfig)));
    }

    @VisibleForTesting
    static Map<String, ?> generateServiceConfigWithLoadBalancingConfig(Collection<String> clusters) {
        HashMap<String, Map<String, List<Map<String, Map<String, String>>>>> childPolicy = new HashMap<String, Map<String, List<Map<String, Map<String, String>>>>>();
        for (String cluster : clusters) {
            List<Map<String, Map<String, String>>> lbPolicy = Collections.singletonList(Collections.singletonMap("cds_experimental", Collections.singletonMap("cluster", cluster)));
            childPolicy.put(cluster, Collections.singletonMap("lbPolicy", lbPolicy));
        }
        return Collections.singletonMap("loadBalancingConfig", Collections.singletonList(Collections.singletonMap("cluster_manager_experimental", Collections.singletonMap("childPolicy", Collections.unmodifiableMap(childPolicy)))));
    }

    @VisibleForTesting
    XdsClient getXdsClient() {
        return this.xdsClient;
    }

    private void updateResolutionResult() {
        Map<String, ?> rawServiceConfig = XdsNameResolver.generateServiceConfigWithLoadBalancingConfig(this.clusterRefs.keySet());
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Generated service config:\n{0}", new Gson().toJson(rawServiceConfig));
        }
        NameResolver.ConfigOrError parsedServiceConfig = this.serviceConfigParser.parseServiceConfig(rawServiceConfig);
        Attributes attrs = Attributes.newBuilder().set(InternalXdsAttributes.XDS_CLIENT_POOL, this.xdsClientPool).set(InternalXdsAttributes.CALL_COUNTER_PROVIDER, (Object)this.callCounterProvider).set(InternalConfigSelector.KEY, (Object)this.configSelector).build();
        NameResolver.ResolutionResult result = NameResolver.ResolutionResult.newBuilder().setAttributes(attrs).setServiceConfig(parsedServiceConfig).build();
        this.listener.onResult(result);
    }

    @Nullable
    @VisibleForTesting
    static VirtualHost findVirtualHostForHostName(List<VirtualHost> virtualHosts, String hostName) {
        int matchingLen = -1;
        boolean exactMatchFound = false;
        VirtualHost targetVirtualHost = null;
        for (VirtualHost vHost : virtualHosts) {
            for (String domain : vHost.domains()) {
                boolean selected = false;
                if (XdsNameResolver.matchHostName(hostName, domain)) {
                    if (!domain.contains("*")) {
                        exactMatchFound = true;
                        targetVirtualHost = vHost;
                        break;
                    }
                    if (domain.length() > matchingLen) {
                        selected = true;
                    } else if (domain.length() == matchingLen && domain.startsWith("*")) {
                        selected = true;
                    }
                }
                if (!selected) continue;
                matchingLen = domain.length();
                targetVirtualHost = vHost;
            }
            if (!exactMatchFound) continue;
            break;
        }
        return targetVirtualHost;
    }

    @VisibleForTesting
    static boolean matchHostName(String hostName, String pattern) {
        Preconditions.checkArgument((hostName.length() != 0 && !hostName.startsWith(".") && !hostName.endsWith(".") ? 1 : 0) != 0, (Object)"Invalid host name");
        Preconditions.checkArgument((pattern.length() != 0 && !pattern.startsWith(".") && !pattern.endsWith(".") ? 1 : 0) != 0, (Object)"Invalid pattern/domain name");
        hostName = hostName.toLowerCase(Locale.US);
        pattern = pattern.toLowerCase(Locale.US);
        if (!pattern.contains("*")) {
            return hostName.equals(pattern);
        }
        if (pattern.length() == 1) {
            return true;
        }
        int index = pattern.indexOf(42);
        if (pattern.indexOf(42, index + 1) != -1) {
            return false;
        }
        if (index != 0 && index != pattern.length() - 1) {
            return false;
        }
        if (hostName.length() < pattern.length()) {
            return false;
        }
        if (index == 0 && hostName.endsWith(pattern.substring(1))) {
            return true;
        }
        return index == pattern.length() - 1 && hostName.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    @VisibleForTesting
    static boolean matchRoute(VirtualHost.Route.RouteMatch routeMatch, String fullMethodName, Map<String, Iterable<String>> headers, ThreadSafeRandom random) {
        if (!XdsNameResolver.matchPath(routeMatch.pathMatcher(), fullMethodName)) {
            return false;
        }
        for (Matchers.HeaderMatcher headerMatcher : routeMatch.headerMatchers()) {
            Iterable<String> headerValues = headers.get(headerMatcher.name());
            if (headerMatcher.name().equals("grpc-previous-rpc-attempts")) {
                headerValues = null;
            }
            if (headerMatcher.name().equals("content-type")) {
                headerValues = Collections.singletonList("application/grpc");
            }
            if (XdsNameResolver.matchHeader(headerMatcher, headerValues)) continue;
            return false;
        }
        Matchers.FractionMatcher fraction = routeMatch.fractionMatcher();
        return fraction == null || random.nextInt(fraction.denominator()) < fraction.numerator();
    }

    @VisibleForTesting
    static boolean matchPath(Matchers.PathMatcher pathMatcher, String fullMethodName) {
        if (pathMatcher.path() != null) {
            return pathMatcher.caseSensitive() ? pathMatcher.path().equals(fullMethodName) : pathMatcher.path().equalsIgnoreCase(fullMethodName);
        }
        if (pathMatcher.prefix() != null) {
            return pathMatcher.caseSensitive() ? fullMethodName.startsWith(pathMatcher.prefix()) : fullMethodName.toLowerCase().startsWith(pathMatcher.prefix().toLowerCase());
        }
        return pathMatcher.regEx().matches(fullMethodName);
    }

    @VisibleForTesting
    static boolean matchHeader(Matchers.HeaderMatcher headerMatcher, @Nullable Iterable<String> headerValues) {
        boolean baseMatch;
        if (headerMatcher.present() != null) {
            return headerValues == null == headerMatcher.present().equals(headerMatcher.inverted());
        }
        if (headerValues == null) {
            return false;
        }
        String valueStr = Joiner.on((String)",").join(headerValues);
        if (headerMatcher.exactValue() != null) {
            baseMatch = headerMatcher.exactValue().equals(valueStr);
        } else if (headerMatcher.safeRegEx() != null) {
            baseMatch = headerMatcher.safeRegEx().matches(valueStr);
        } else if (headerMatcher.range() != null) {
            try {
                long numValue = Long.parseLong(valueStr);
                baseMatch = numValue >= headerMatcher.range().start() && numValue <= headerMatcher.range().end();
            }
            catch (NumberFormatException ignored) {
                baseMatch = false;
            }
        } else {
            baseMatch = headerMatcher.prefix() != null ? valueStr.startsWith(headerMatcher.prefix()) : valueStr.endsWith(headerMatcher.suffix());
        }
        return baseMatch != headerMatcher.inverted();
    }

    private static class RoutingConfig {
        private static final RoutingConfig empty = new RoutingConfig(0L, Collections.emptyList());
        private final long fallbackTimeoutNano;
        private final List<VirtualHost.Route> routes;

        private RoutingConfig(long fallbackTimeoutNano, List<VirtualHost.Route> routes) {
            this.fallbackTimeoutNano = fallbackTimeoutNano;
            this.routes = routes;
        }
    }

    private class ResolveState
    implements XdsClient.LdsResourceWatcher {
        private final NameResolver.ConfigOrError emptyServiceConfig;
        private final NameResolver.ResolutionResult emptyResult;
        private boolean stopped;
        @Nullable
        private Set<String> existingClusters;
        @Nullable
        private RouteDiscoveryState routeDiscoveryState;

        private ResolveState() {
            this.emptyServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(Collections.emptyMap());
            this.emptyResult = NameResolver.ResolutionResult.newBuilder().setServiceConfig(this.emptyServiceConfig).build();
        }

        @Override
        public void onChanged(final XdsClient.LdsUpdate update) {
            XdsNameResolver.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (ResolveState.this.stopped) {
                        return;
                    }
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Receive LDS resource update: {0}", update);
                    List<VirtualHost> virtualHosts = update.virtualHosts;
                    String rdsName = update.rdsName;
                    ResolveState.this.cleanUpRouteDiscoveryState();
                    if (virtualHosts != null) {
                        ResolveState.this.updateRoutes(virtualHosts, update.httpMaxStreamDurationNano);
                    } else {
                        ResolveState.this.routeDiscoveryState = new RouteDiscoveryState(rdsName, update.httpMaxStreamDurationNano);
                        XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching RDS resource {0}", rdsName);
                        XdsNameResolver.this.xdsClient.watchRdsResource(rdsName, ResolveState.this.routeDiscoveryState);
                    }
                }
            });
        }

        @Override
        public void onError(final Status error) {
            XdsNameResolver.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (ResolveState.this.stopped) {
                        return;
                    }
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", XdsNameResolver.this.xdsClient, error.getDescription());
                    XdsNameResolver.this.listener.onError(error);
                }
            });
        }

        @Override
        public void onResourceDoesNotExist(final String resourceName) {
            XdsNameResolver.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (ResolveState.this.stopped) {
                        return;
                    }
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "LDS resource {0} unavailable", resourceName);
                    ResolveState.this.cleanUpRouteDiscoveryState();
                    ResolveState.this.cleanUpRoutes();
                }
            });
        }

        private void start() {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching LDS resource {0}", XdsNameResolver.this.authority);
            XdsNameResolver.this.xdsClient.watchLdsResource(XdsNameResolver.this.authority, this);
        }

        private void stop() {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching LDS resource {0}", XdsNameResolver.this.authority);
            this.stopped = true;
            this.cleanUpRouteDiscoveryState();
            XdsNameResolver.this.xdsClient.cancelLdsResourceWatch(XdsNameResolver.this.authority, this);
        }

        private void updateRoutes(List<VirtualHost> virtualHosts, long httpMaxStreamDurationNano) {
            VirtualHost virtualHost = XdsNameResolver.findVirtualHostForHostName(virtualHosts, XdsNameResolver.this.authority);
            if (virtualHost == null) {
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to find virtual host matching hostname {0}", XdsNameResolver.this.authority);
                this.cleanUpRoutes();
                return;
            }
            ImmutableList<VirtualHost.Route> routes = virtualHost.routes();
            Sets.SetView clusters = new HashSet();
            for (VirtualHost.Route route : routes) {
                VirtualHost.Route.RouteAction action = route.routeAction();
                if (action.cluster() != null) {
                    clusters.add(action.cluster());
                    continue;
                }
                if (action.weightedClusters() == null) continue;
                for (VirtualHost.Route.RouteAction.ClusterWeight weighedCluster : action.weightedClusters()) {
                    clusters.add(weighedCluster.name());
                }
            }
            boolean shouldUpdateResult = this.existingClusters == null;
            Sets.SetView addedClusters = this.existingClusters == null ? clusters : Sets.difference(clusters, this.existingClusters);
            Sets.SetView deletedClusters = this.existingClusters == null ? Collections.emptySet() : Sets.difference(this.existingClusters, (Set)clusters);
            this.existingClusters = clusters;
            for (String cluster : addedClusters) {
                if (XdsNameResolver.this.clusterRefs.containsKey(cluster)) {
                    ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).incrementAndGet();
                    continue;
                }
                XdsNameResolver.this.clusterRefs.put(cluster, new AtomicInteger(1));
                shouldUpdateResult = true;
            }
            if (shouldUpdateResult) {
                XdsNameResolver.this.updateResolutionResult();
            }
            XdsNameResolver.this.routingConfig = new RoutingConfig(httpMaxStreamDurationNano, (List)routes);
            shouldUpdateResult = false;
            for (String cluster : deletedClusters) {
                int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
                if (count != 0) continue;
                XdsNameResolver.this.clusterRefs.remove(cluster);
                shouldUpdateResult = true;
            }
            if (shouldUpdateResult) {
                XdsNameResolver.this.updateResolutionResult();
            }
        }

        private void cleanUpRoutes() {
            if (this.existingClusters != null) {
                for (String cluster : this.existingClusters) {
                    int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
                    if (count != 0) continue;
                    XdsNameResolver.this.clusterRefs.remove(cluster);
                }
                this.existingClusters = null;
            }
            XdsNameResolver.this.routingConfig = RoutingConfig.empty;
            XdsNameResolver.this.listener.onResult(this.emptyResult);
        }

        private void cleanUpRouteDiscoveryState() {
            if (this.routeDiscoveryState != null) {
                String rdsName = this.routeDiscoveryState.resourceName;
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching RDS resource {0}", rdsName);
                XdsNameResolver.this.xdsClient.cancelRdsResourceWatch(rdsName, this.routeDiscoveryState);
                this.routeDiscoveryState = null;
            }
        }

        private class RouteDiscoveryState
        implements XdsClient.RdsResourceWatcher {
            private final String resourceName;
            private final long httpMaxStreamDurationNano;

            private RouteDiscoveryState(String resourceName, long httpMaxStreamDurationNano) {
                this.resourceName = resourceName;
                this.httpMaxStreamDurationNano = httpMaxStreamDurationNano;
            }

            @Override
            public void onChanged(final XdsClient.RdsUpdate update) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (RouteDiscoveryState.this != ResolveState.this.routeDiscoveryState) {
                            return;
                        }
                        XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received RDS resource update: {0}", update);
                        ResolveState.this.updateRoutes(update.virtualHosts, RouteDiscoveryState.this.httpMaxStreamDurationNano);
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (RouteDiscoveryState.this != ResolveState.this.routeDiscoveryState) {
                            return;
                        }
                        XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", XdsNameResolver.this.xdsClient, error.getDescription());
                        XdsNameResolver.this.listener.onError(error);
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (RouteDiscoveryState.this != ResolveState.this.routeDiscoveryState) {
                            return;
                        }
                        XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "RDS resource {0} unavailable", resourceName);
                        ResolveState.this.cleanUpRoutes();
                    }
                });
            }
        }
    }

    private final class ConfigSelector
    extends InternalConfigSelector {
        private ConfigSelector() {
        }

        public InternalConfigSelector.Result selectConfig(LoadBalancer.PickSubchannelArgs args) {
            NameResolver.ConfigOrError parsedServiceConfig;
            Object config;
            HashMap<String, Iterable<String>> asciiHeaders = new HashMap<String, Iterable<String>>();
            Metadata headers = args.getHeaders();
            for (String headerName : headers.keys()) {
                if (headerName.endsWith("-bin")) continue;
                Metadata.Key key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                asciiHeaders.put(headerName, headers.getAll(key));
            }
            String cluster = null;
            VirtualHost.Route selectedRoute = null;
            block1: do {
                for (VirtualHost.Route route : XdsNameResolver.this.routingConfig.routes) {
                    if (!XdsNameResolver.matchRoute(route.routeMatch(), "/" + args.getMethodDescriptor().getFullMethodName(), asciiHeaders, XdsNameResolver.this.random)) continue;
                    selectedRoute = route;
                    break;
                }
                if (selectedRoute == null) {
                    return InternalConfigSelector.Result.forError((Status)Status.UNAVAILABLE.withDescription("Could not find xDS route matching RPC"));
                }
                VirtualHost.Route.RouteAction action = selectedRoute.routeAction();
                if (action.cluster() != null) {
                    cluster = action.cluster();
                    continue;
                }
                if (action.weightedClusters() == null) continue;
                int totalWeight = 0;
                for (VirtualHost.Route.RouteAction.ClusterWeight weightedCluster : action.weightedClusters()) {
                    totalWeight += weightedCluster.weight();
                }
                int select = XdsNameResolver.this.random.nextInt(totalWeight);
                int accumulator = 0;
                for (VirtualHost.Route.RouteAction.ClusterWeight weightedCluster : action.weightedClusters()) {
                    if (select >= (accumulator += weightedCluster.weight())) continue;
                    cluster = weightedCluster.name();
                    continue block1;
                }
            } while (!this.retainCluster(cluster));
            Map<Object, Object> rawServiceConfig = Collections.emptyMap();
            if (enableTimeout) {
                Long timeoutNano = selectedRoute.routeAction().timeoutNano();
                if (timeoutNano == null) {
                    timeoutNano = XdsNameResolver.this.routingConfig.fallbackTimeoutNano;
                }
                if (timeoutNano > 0L) {
                    rawServiceConfig = XdsNameResolver.generateServiceConfigWithMethodTimeoutConfig(timeoutNano);
                }
            }
            if ((config = (parsedServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(rawServiceConfig)).getConfig()) == null) {
                this.releaseCluster(cluster);
                return InternalConfigSelector.Result.forError((Status)parsedServiceConfig.getError().augmentDescription("Failed to parse service config (method config)"));
            }
            final String finalCluster = cluster;
            class ClusterSelectionInterceptor
            implements ClientInterceptor {
                ClusterSelectionInterceptor() {
                }

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    CallOptions callOptionsForCluster = callOptions.withOption(CLUSTER_SELECTION_KEY, (Object)finalCluster);
                    return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptionsForCluster)){

                        public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                            listener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>((ClientCall.Listener)listener){
                                boolean committed;

                                public void onHeaders(Metadata headers) {
                                    this.committed = true;
                                    ConfigSelector.this.releaseCluster(finalCluster);
                                    this.delegate().onHeaders(headers);
                                }

                                public void onClose(Status status, Metadata trailers) {
                                    if (!this.committed) {
                                        ConfigSelector.this.releaseCluster(finalCluster);
                                    }
                                    this.delegate().onClose(status, trailers);
                                }
                            };
                            this.delegate().start(listener, headers);
                        }
                    };
                }
            }
            return InternalConfigSelector.Result.newBuilder().setConfig(config).setInterceptor((ClientInterceptor)new ClusterSelectionInterceptor()).build();
        }

        private boolean retainCluster(String cluster) {
            int count;
            AtomicInteger refCount = (AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster);
            if (refCount == null) {
                return false;
            }
            do {
                if ((count = refCount.get()) != 0) continue;
                return false;
            } while (!refCount.compareAndSet(count, count + 1));
            return true;
        }

        private void releaseCluster(final String cluster) {
            int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
            if (count == 0) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).get() == 0) {
                            XdsNameResolver.this.clusterRefs.remove(cluster);
                            XdsNameResolver.this.updateResolutionResult();
                        }
                    }
                });
            }
        }
    }
}

