/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.internal.certprovider.CertificateProvider;
import io.grpc.xds.internal.certprovider.CertificateProviderProvider;
import io.grpc.xds.internal.certprovider.DynamicReloadingCertificateProvider;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

final class DynamicReloadingCertificateProviderProvider
implements CertificateProviderProvider {
    private static final String DIRECTORY_KEY = "directory";
    private static final String CERT_FILE_KEY = "certificate-file";
    private static final String KEY_FILE_KEY = "private-key-file";
    private static final String ROOT_FILE_KEY = "ca-certificate-file";
    private static final String REFRESH_INTERVAL_KEY = "refresh-interval";
    @VisibleForTesting
    static final long REFRESH_INTERVAL_DEFAULT = 600L;
    static final String DYNAMIC_RELOADING_PROVIDER_NAME = "gke-cas-certs";
    final DynamicReloadingCertificateProvider.Factory dynamicReloadingCertificateProviderFactory;
    private final ScheduledExecutorServiceFactory scheduledExecutorServiceFactory;
    private final TimeProvider timeProvider;

    DynamicReloadingCertificateProviderProvider() {
        this(DynamicReloadingCertificateProvider.Factory.getInstance(), ScheduledExecutorServiceFactory.DEFAULT_INSTANCE, TimeProvider.SYSTEM_TIME_PROVIDER);
    }

    @VisibleForTesting
    DynamicReloadingCertificateProviderProvider(DynamicReloadingCertificateProvider.Factory dynamicReloadingCertificateProviderFactory, ScheduledExecutorServiceFactory scheduledExecutorServiceFactory, TimeProvider timeProvider) {
        this.dynamicReloadingCertificateProviderFactory = dynamicReloadingCertificateProviderFactory;
        this.scheduledExecutorServiceFactory = scheduledExecutorServiceFactory;
        this.timeProvider = timeProvider;
    }

    @Override
    public String getName() {
        return DYNAMIC_RELOADING_PROVIDER_NAME;
    }

    @Override
    public CertificateProvider createCertificateProvider(Object config, CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates) {
        Config configObj = DynamicReloadingCertificateProviderProvider.validateAndTranslateConfig(config);
        return this.dynamicReloadingCertificateProviderFactory.create(watcher, notifyCertUpdates, configObj.directory, configObj.certFile, configObj.keyFile, configObj.rootFile, configObj.refrehInterval, this.scheduledExecutorServiceFactory.create(), this.timeProvider);
    }

    private static String checkForNullAndGet(Map<String, ?> map, String key) {
        return (String)Preconditions.checkNotNull((Object)JsonUtil.getString(map, (String)key), (Object)("'" + key + "' is required in the config"));
    }

    private static Config validateAndTranslateConfig(Object config) {
        Preconditions.checkArgument((boolean)(config instanceof Map), (Object)"Only Map supported for config");
        Map map = (Map)config;
        Config configObj = new Config();
        configObj.directory = DynamicReloadingCertificateProviderProvider.checkForNullAndGet(map, DIRECTORY_KEY);
        configObj.certFile = DynamicReloadingCertificateProviderProvider.checkForNullAndGet(map, CERT_FILE_KEY);
        configObj.keyFile = DynamicReloadingCertificateProviderProvider.checkForNullAndGet(map, KEY_FILE_KEY);
        configObj.rootFile = DynamicReloadingCertificateProviderProvider.checkForNullAndGet(map, ROOT_FILE_KEY);
        configObj.refrehInterval = JsonUtil.getNumberAsLong((Map)map, (String)REFRESH_INTERVAL_KEY);
        if (configObj.refrehInterval == null) {
            configObj.refrehInterval = 600L;
        }
        return configObj;
    }

    @VisibleForTesting
    static class Config {
        String directory;
        String certFile;
        String keyFile;
        String rootFile;
        Long refrehInterval;

        Config() {
        }
    }

    static abstract class ScheduledExecutorServiceFactory {
        private static final ScheduledExecutorServiceFactory DEFAULT_INSTANCE = new ScheduledExecutorServiceFactory(){

            @Override
            ScheduledExecutorService create() {
                return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("dynamicReloading-%d").setDaemon(true).build());
            }
        };

        ScheduledExecutorServiceFactory() {
        }

        abstract ScheduledExecutorService create();
    }
}

