/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.processInfo.oshi;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.processInfo.ProcessInfoFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OshiProcessInfoFactory
extends ProcessInfoFactory {
    private static SystemInfo sysInfo;

    public ProcessInfoFactory.ProcessInfo create(long pid) {
        OshiProcessInfo result;
        if (pid > 0L) {
            if (null == sysInfo) {
                sysInfo = new SystemInfo();
            }
            OperatingSystem os = sysInfo.getOperatingSystem();
            result = new OshiProcessInfo(os.getProcess((int)pid));
        } else {
            result = new OshiProcessInfo(null);
        }
        return result;
    }

    public long getProcessId(Process proc) {
        long result = -1L;
        if (proc != null) {
            try {
                try {
                    Method meth = Process.class.getDeclaredMethod("pid", new Class[0]);
                    Object tmp = meth.invoke((Object)proc, new Object[0]);
                    if (tmp instanceof Long) {
                        result = (Long)tmp;
                    }
                }
                catch (NoSuchMethodException e) {
                    Field pidField = Process.class.getDeclaredField("pid");
                    pidField.setAccessible(true);
                    result = pidField.getLong(proc);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot obtain processId for {}: {}", (Object)proc, (Object)e.getMessage());
            }
        }
        return result;
    }

    public long getProcessId() {
        long result = -1L;
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String jvmName = runtimeBean.getName();
        int index = jvmName.indexOf(64);
        if (index > 0) {
            String pidString = jvmName.substring(0, index);
            try {
                result = Long.parseLong(pidString);
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not parse PID from JVM name: {}", (Object)jvmName);
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not extract PID from JVM name: " + jvmName);
        }
        return result;
    }

    private static class OshiProcessInfo
    implements ProcessInfoFactory.ProcessInfo {
        private OSProcess proc;

        private OshiProcessInfo(OSProcess proc) {
            this.proc = proc;
        }

        public long getVirtualSize() {
            return null == this.proc ? 0L : this.proc.getVirtualSize();
        }
    }
}

