/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.rest.spark;

import de.iip_ecosphere.platform.support.rest.RestTarget;
import java.io.IOException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;

public class JerseyWebTarget
implements RestTarget {
    private WebTarget webTarget;

    JerseyWebTarget(String uri) {
        this.webTarget = ClientBuilder.newClient().target(uri);
    }

    public RestTarget.Request createRequest() {
        return new JerseyRequest(this.webTarget);
    }

    private class JerseyRequest
    implements RestTarget.Request {
        private WebTarget webTarget;

        private JerseyRequest(WebTarget webTarget) {
            this.webTarget = webTarget;
        }

        public RestTarget.Request addPath(String path) {
            this.webTarget = this.webTarget.path(path);
            return this;
        }

        public RestTarget.Request addQueryParam(String name, String ... values) {
            this.webTarget = this.webTarget.queryParam("tag", (Object[])values);
            return this;
        }

        public RestTarget.Invocation requestJson() {
            return new JerseyInvocationBuilder(this.webTarget, "application/json");
        }
    }

    private class JerseyInvocationBuilder
    implements RestTarget.Invocation {
        private Invocation.Builder invocationBuilder;
        private String mediaType;

        private JerseyInvocationBuilder(WebTarget webTarget, String mediaType) {
            this.mediaType = mediaType;
            this.invocationBuilder = webTarget.request(new String[]{mediaType});
        }

        public <T> T get(Class<T> cls) throws IOException {
            try {
                return (T)this.invocationBuilder.get().readEntity(cls);
            }
            catch (IllegalStateException | ProcessingException e) {
                throw new IOException(e);
            }
        }

        public void put(String body) throws IOException {
            try {
                Entity entity;
                switch (this.mediaType) {
                    case "application/json": {
                        entity = Entity.json((Object)body);
                        break;
                    }
                    default: {
                        entity = Entity.text((Object)body);
                    }
                }
                this.invocationBuilder.put(entity);
            }
            catch (IllegalStateException | ProcessingException e) {
                throw new IOException(e);
            }
        }

        public void delete() throws IOException {
            try {
                this.invocationBuilder.delete();
            }
            catch (IllegalStateException | ProcessingException e) {
                throw new IOException(e);
            }
        }
    }
}

