/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.rest.spark;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.rest.Rest;
import de.iip_ecosphere.platform.support.rest.RestTarget;
import de.oktoflow.platform.support.rest.spark.SparkRest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class RestTest {
    @Test
    public void testRest() throws IOException {
        Rest rest = Rest.getInstance();
        Assert.assertTrue((boolean)(rest instanceof SparkRest));
        String json = "{\"received\":true}";
        Rest.Route route = (req, res) -> {
            res.setBody("{\"received\":true}");
            res.setStatus(200);
            return res.getBody();
        };
        String path = "/test/route";
        int port = NetUtils.getEphemeralPort();
        Rest.RestServer server = Rest.getInstance().createServer(port);
        server.definePost("/test/route", route);
        server.defineGet("/test/route", route);
        server.definePut("/test/route", route);
        server.defineDelete("/test/route", route);
        server.start();
        TimeUtils.sleep((int)500);
        RestTarget t = rest.createTarget("http://localhost:" + port + "/");
        String result = t.createRequest().addPath("test").addPath("route").addQueryParam("param", new String[]{"a", "b"}).requestJson().getAsString();
        Assert.assertEquals((Object)"{\"received\":true}", (Object)result);
        t.createRequest().addPath("test").addPath("route").requestJson().put("{\"request\":\"abc\"");
        t.createRequest().addPath("test").addPath("route").requestJson().delete();
        server.stop(true);
    }
}

