/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.ws.websocket;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.websocket.WebsocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;

public class WebsocketWebsocketFactory
extends WebsocketFactory {
    protected static Logger getLogger() {
        return LoggerFactory.getLogger(WebsocketWebsocketFactory.class);
    }

    public WebSocketImpl createSocket(URI uri) throws IOException {
        return new WebSocketImpl(uri);
    }

    public Server createBroadcastingServer(final ServerAddress address) throws IOException {
        return new Server(){
            private BroadcastingWsServer server;

            public Server start() {
                LoggerFactory.getLogger(WebsocketWebsocketFactory.class).info("Starting Websocket broadcasting server on {}:{}", (Object)address.getHost(), (Object)address.getPort());
                this.server = new BroadcastingWsServer(address);
                new Thread((Runnable)((Object)this.server)).start();
                return this;
            }

            public void stop(boolean dispose) {
                try {
                    this.server.stop(1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    private static class WebSocketImpl
    implements WebsocketFactory.WebSocket {
        private WebSocketClientImpl client;

        public WebSocketImpl(URI serverUri) {
            this.client = new WebSocketClientImpl(serverUri);
        }

        public void connect() throws IOException {
            this.client.connect();
        }

        public boolean connectBlocking() throws IOException {
            try {
                return this.client.connectBlocking();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void close() throws IOException {
            this.client.close();
        }

        public void setReceptionHander(Consumer<String> receptionHandler) {
            this.client.receptionHandler = receptionHandler;
        }

        public void setStatusListener(WebsocketFactory.StatusListener listener) {
            this.client.statusListener = listener;
        }

        public void send(String text) throws IOException {
            try {
                this.client.send(text);
            }
            catch (WebsocketNotConnectedException e) {
                throw new IOException(e);
            }
        }

        public void closeBocking() throws IOException {
            try {
                this.client.closeBlocking();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public URI getURI() {
            return this.client.getURI();
        }

        public boolean isOpen() {
            return this.client.isOpen();
        }

        public boolean isClosed() {
            return this.client.isClosed();
        }
    }

    private static class BroadcastingWsServer
    extends WebSocketServer {
        private ServerAddress address;
        private Map<String, List<WebSocket>> connections = Collections.synchronizedMap(new HashMap());

        BroadcastingWsServer(ServerAddress address) {
            super(new InetSocketAddress(address.getHost(), address.getPort()));
            this.setReuseAddr(false);
            this.address = address;
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
            List<Object> cList = this.connections.get(conn.getResourceDescriptor());
            if (null == cList) {
                cList = Collections.synchronizedList(new ArrayList());
                this.connections.put(conn.getResourceDescriptor(), cList);
            }
            cList.add(conn);
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            List<WebSocket> cList = this.connections.get(conn.getResourceDescriptor());
            if (null != cList) {
                cList.remove(conn);
                if (cList.isEmpty()) {
                    this.connections.remove(conn.getResourceDescriptor());
                }
            }
        }

        public void onMessage(WebSocket conn, String message) {
            List<WebSocket> cList = this.connections.get(conn.getResourceDescriptor());
            if (null != cList) {
                for (int c = 0; c < cList.size(); ++c) {
                    cList.get(c).send(message);
                }
            }
        }

        public void onError(WebSocket conn, Exception ex) {
            WebsocketWebsocketFactory.getLogger().error("Error on {}: {}", (Object)conn.getRemoteSocketAddress(), (Object)ex.getMessage());
        }

        public void onStart() {
            WebsocketWebsocketFactory.getLogger().info("Started websocket broadcasting server on {}:{}", (Object)this.address.getHost(), (Object)this.address.getPort());
        }
    }

    private static class WebSocketClientImpl
    extends WebSocketClient {
        private Consumer<String> receptionHandler = s -> WebsocketWebsocketFactory.getLogger().info("No response handler set, ignoring: {}", s);
        private WebsocketFactory.StatusListener statusListener;
        private String lastError;

        public WebSocketClientImpl(URI serverUri) {
            super(serverUri);
        }

        public WebSocketClientImpl(URI serverUri, Map<String, String> httpHeaders) {
            super(serverUri, httpHeaders);
        }

        public void onOpen(ServerHandshake handshakedata) {
            if (null != this.statusListener) {
                this.statusListener.onConnect();
            }
        }

        public void onMessage(String message) {
            if (null != this.receptionHandler) {
                this.receptionHandler.accept(message);
            }
        }

        public void onClose(int code, String reason, boolean remote) {
            if (remote) {
                WebsocketWebsocketFactory.getLogger().info("Connection closed by remote peer, code: {} reason: {}", (Object)code, (Object)reason);
            }
            if (null != this.statusListener) {
                this.statusListener.onClose(reason, remote);
            }
        }

        public void onError(Exception ex) {
            String msg = ex.getMessage();
            if (null == this.lastError || !this.lastError.equals(msg)) {
                this.lastError = msg;
                WebsocketWebsocketFactory.getLogger().error("While running WebSocket client: {}", (Object)ex.getMessage());
                if (null != this.statusListener) {
                    this.statusListener.onError(msg);
                }
            }
        }
    }
}

