/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.yaml.snakeyaml;

import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.function.IOFunction;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.yaml.Yaml;
import de.oktoflow.platform.support.yaml.snakeyaml.SnakeYaml;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class YamlTest {
    private static <T> T fromResource(IOFunction<InputStream, T> func) throws IOException {
        return YamlTest.fromResource("nameplate.yml", func);
    }

    private static <T> T fromResource(String resource, IOFunction<InputStream, T> func) throws IOException {
        InputStream in = ResourceLoader.getResourceAsStream((String)resource, (ResourceResolver[])new ResourceResolver[0]);
        Object result = func.apply((Object)in);
        in.close();
        return (T)result;
    }

    @Test
    public void testYaml() throws IOException {
        Yaml yaml = Yaml.getInstance();
        Assert.assertTrue((boolean)(yaml instanceof SnakeYaml));
        Assert.assertNotNull(YamlTest.fromResource(in -> yaml.load(in)));
        Assert.assertNotNull(YamlTest.fromResource(in -> yaml.loadMapping(in)));
        Assert.assertNotNull(YamlTest.fromResource(in -> yaml.loadAs(in, Object.class)));
        Assert.assertNotNull(YamlTest.fromResource(in -> yaml.loadTolerantAs(in, Object.class)));
        Iterator iter = (Iterator)YamlTest.fromResource(in -> yaml.loadAll(in, Object.class));
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertNotNull(iter.next());
        iter = (Iterator)YamlTest.fromResource("nameplate-path.yml", in -> yaml.loadAll(in, "outer", Object.class));
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertNotNull(iter.next());
        String s = (String)YamlTest.fromResource(in -> IOUtils.toString((InputStream)in));
        Assert.assertNotNull((Object)yaml.loadAs(s, Object.class));
        Assert.assertNotNull((Object)yaml.dump(new Object()));
        yaml.dump(new Object(), (Writer)new CharArrayWriter());
        yaml.dump(new Object(), Object.class, (Writer)new CharArrayWriter());
    }
}

