/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilsTest {
    private static int numberTestFiles = 32;
    private static int numberTestNotServiceFiles = 20;

    protected static void setNumberTestFiles(int number) {
        numberTestFiles = number;
    }

    protected static void setNumberTestNotServiceFiles(int number) {
        numberTestNotServiceFiles = number;
    }

    @Test
    public void testTempDir() {
        Assert.assertNotNull((Object)FileUtils.getTempDirectoryPath());
        Assert.assertNotNull((Object)FileUtils.getTempDirectory());
    }

    @Test
    public void testCreateTmpFolder() {
        String tmp = FileUtils.getTempDirectoryPath();
        File created = FileUtils.createTmpFolder((String)"support.test");
        Assert.assertTrue((boolean)created.toString().startsWith(tmp));
        Assert.assertTrue((boolean)created.exists());
        Assert.assertTrue((boolean)created.canRead());
        Assert.assertTrue((boolean)created.canWrite());
        FileUtils.deleteQuietly((File)created);
    }

    @Test
    public void testCloseQuietly() {
        FileUtils.closeQuietly(null);
        Closeable cl = new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        FileUtils.closeQuietly((Closeable)cl);
    }

    @Test
    public void testListFiles() {
        File f = new File("src/test/resources");
        AtomicInteger fileCount = new AtomicInteger();
        FileUtils.listFiles((File)f, g -> true, g -> fileCount.incrementAndGet());
        Assert.assertEquals((long)numberTestFiles, (long)fileCount.get());
        fileCount.set(0);
        FileUtils.listFiles((File)f, g -> !g.getName().equals("services"), g -> fileCount.incrementAndGet());
        Assert.assertEquals((long)numberTestNotServiceFiles, (long)fileCount.get());
    }

    @Test
    public void testResolution() {
        Assert.assertNotNull((Object)FileUtils.getResolvedFile((File)new File(".")));
        Assert.assertNotNull((Object)FileUtils.getResolvedPath((File)new File("."), (String)""));
        Assert.assertNotNull((Object)FileUtils.getResolvedPath((File)new File("."), (String)"test.txt"));
    }

    @Test
    public void testBase64() throws IOException {
        File src = new File("src/test/resources/Logo.jpg");
        File tgt = new File(FileUtils.getTempDirectory(), "base64.tst");
        tgt.delete();
        String enc = FileUtils.fileToBase64((File)src);
        FileUtils.base64ToFile((String)enc, (File)tgt);
        Assert.assertTrue((boolean)FileUtils.contentEquals((File)src, (File)tgt));
        tgt.delete();
    }

    @Test
    public void testSanitize() {
        Assert.assertEquals((Object)"a", (Object)FileUtils.sanitizeFileName((String)"a"));
        Assert.assertEquals((Object)"a", (Object)FileUtils.sanitizeFileName((String)"a", (boolean)false));
        Assert.assertTrue((boolean)FileUtils.sanitizeFileName((String)"a", (boolean)true).startsWith("a"));
    }

    public void testDeleteOnExit() throws IOException {
        File f = File.createTempFile("iip-test", null);
        FileUtils.deleteOnExit((File)f);
    }

    @Test
    public void testFindFile() {
        File f = FileUtils.findFile((File)new File("."), (String)"identityStore.yml");
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((Object)"identityStore.yml", (Object)f.getName());
        f = FileUtils.findFile((File)new File("."), (String)"identityStoreNotThere.yml");
        Assert.assertNull((Object)f);
    }

    @Test
    public void testSystemRoot() {
        File f = FileUtils.getSystemRoot();
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((f.toString().length() > 0 ? 1 : 0) != 0);
    }
}

