/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.CurrentClassloaderPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.FolderClasspathPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;

public class TestWithPlugin {
    public static final String PROP_AAS_PLUGIN = "okto.test.aas.pluginId";
    private static boolean loaded = false;
    private static List<PluginLocation> locations = new ArrayList<PluginLocation>();
    private static String installDir = "target/oktoPlugins";
    private static List<Runnable> runAfterLoading = new ArrayList<Runnable>();
    private static boolean enableLocalPlugins = true;

    public static void addPluginLocation(String parent, String folder, String ... appends) {
        TestWithPlugin.addPluginLocation(parent, folder, false, appends);
    }

    public static void addPluginLocation(String parent, String folder, boolean descriptorOnly, String ... appends) {
        String installFolder = folder;
        int pos = installFolder.lastIndexOf(46);
        if (pos > 0 && !installFolder.endsWith(".")) {
            installFolder = installFolder.substring(pos + 1);
        }
        TestWithPlugin.addPluginLocation(parent, folder, installFolder, descriptorOnly, appends);
    }

    public static void addPluginLocation(String parent, String folder, String installFolder, boolean descriptorOnly, String ... appends) {
        locations.add(new PluginLocation(parent, folder, installFolder, descriptorOnly, appends));
        LoggerFactory.getLogger(TestWithPlugin.class).info("Added plugin location for {} (descriptor only: {})", (Object)folder, (Object)descriptorOnly);
    }

    private static File[] collectAppends(File base, String[] appends) {
        File[] result;
        if (null == appends || appends.length == 0) {
            result = null;
        } else {
            result = new File[appends.length];
            for (int a = 0; a < appends.length; ++a) {
                result[a] = new File(base, appends[a]);
            }
        }
        return result;
    }

    public static void enableLocalPlugins(boolean enable) {
        enableLocalPlugins = enable;
    }

    public static void setInstallDir(String dir) {
        installDir = dir;
    }

    public static void loadPlugins() {
        if (!loaded) {
            PluginManager.registerPlugin((PluginSetupDescriptor)CurrentClassloaderPluginSetupDescriptor.INSTANCE);
            loaded = true;
            boolean found = false;
            for (PluginLocation loc : locations) {
                File[] appends;
                File folder = TestWithPlugin.findPluginFolder("..", loc.folder);
                if (!folder.isDirectory()) {
                    folder = TestWithPlugin.findPluginFolder("../" + loc.parent, loc.folder);
                }
                if (!folder.isDirectory()) {
                    folder = TestWithPlugin.findPluginFolder("../../" + loc.parent, loc.folder);
                }
                if (enableLocalPlugins && folder.isDirectory()) {
                    LoggerFactory.getLogger(TestWithPlugin.class).info("Loading plugin from {} (development)", (Object)folder);
                    appends = TestWithPlugin.collectAppends(folder.getParentFile(), loc.appends);
                    PluginManager.registerPlugin((PluginSetupDescriptor)new FolderClasspathPluginSetupDescriptor(folder, loc.descriptorOnly, appends));
                    found = true;
                } else {
                    folder = new File(installDir);
                    if (folder.isDirectory()) {
                        appends = TestWithPlugin.collectAppends(folder, loc.appends);
                        LoggerFactory.getLogger(TestWithPlugin.class).info("Loading plugin from {} (test deployment)", (Object)installDir);
                        File cpFile = TestWithPlugin.findPluginFolder(installDir, loc.folder);
                        if (!cpFile.exists()) {
                            cpFile = new File(installDir + "/" + loc.installFolder);
                        }
                        loc.installFolder = cpFile.getName();
                        PluginManager.registerPlugin((PluginSetupDescriptor)new FolderClasspathPluginSetupDescriptor(cpFile, loc.descriptorOnly, appends));
                        found = true;
                    }
                }
                if (found) continue;
                LoggerFactory.getLogger(TestWithPlugin.class).info("No plugins found for {}. Test may fail.", (Object)loc.folder);
            }
            for (Runnable r : runAfterLoading) {
                r.run();
            }
        }
    }

    private static File findPluginFolder(String parent, String child) {
        File par;
        File[] files;
        File result = new File(parent, child);
        if (!result.isDirectory() && null != (files = (par = new File(parent)).listFiles())) {
            for (File f : files) {
                if (!f.getName().startsWith(child + "-") || !f.isDirectory()) continue;
                result = f;
                break;
            }
        }
        return result;
    }

    public static void addRunAfterLoading(Runnable runnable) {
        runAfterLoading.add(runnable);
    }

    public static void clear() {
        locations.clear();
    }

    @Before
    public void setup() {
        TestWithPlugin.loadPlugins();
    }

    private static class PluginLocation {
        private String parent;
        private String folder;
        private String installFolder;
        private boolean descriptorOnly;
        private String[] appends;

        private PluginLocation(String parent, String folder, String installFolder, boolean descriptorOnly, String ... appends) {
            this.parent = parent;
            this.folder = folder;
            this.installFolder = installFolder;
            this.descriptorOnly = descriptorOnly;
            this.appends = appends;
        }
    }
}

