/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.websocket.WebsocketFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class WebsocketTest {
    @Test
    public void testWs() throws IOException, URISyntaxException {
        WebsocketFactory ws = WebsocketFactory.getInstance();
        Assert.assertNotNull((Object)ws);
        WebsocketFactory.setInstance((WebsocketFactory)ws);
        ServerAddress address = new ServerAddress(Schema.WS);
        Server server = ws.createBroadcastingServer(address);
        server.start();
        ArrayList received = new ArrayList();
        URI serverURI = new URI(address.toServerUri());
        WebsocketFactory.WebSocket senderReceiver = ws.createSocket(serverURI);
        WsStatusListener senderReceiverListener = new WsStatusListener();
        senderReceiver.setStatusListener((WebsocketFactory.StatusListener)senderReceiverListener);
        senderReceiver.setReceptionHander(s -> received.add(s));
        senderReceiver.connectBlocking();
        Assert.assertTrue((boolean)senderReceiverListener.connected);
        senderReceiver.connect();
        senderReceiver.send("ABC");
        TimeUtils.sleep((int)300);
        Assert.assertTrue((boolean)received.contains("ABC"));
        senderReceiver.close();
        Assert.assertTrue((!senderReceiverListener.connected ? 1 : 0) != 0);
        server.stop(true);
    }

    private class WsStatusListener
    implements WebsocketFactory.StatusListener {
        private boolean connected = false;

        private WsStatusListener() {
        }

        public void onConnect() {
            this.connected = true;
        }

        public void onClose(String reason, boolean remote) {
            this.connected = false;
        }

        public void onError(String message) {
            System.out.println("ERROR: " + message);
        }
    }
}

