/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.websocket;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.websocket.WebsocketFactory;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;

public class TestWebsocket
extends WebsocketFactory {
    public WebsocketFactory.WebSocket createSocket(final URI uri) throws IOException {
        return new WebsocketFactory.WebSocket(){
            private WebsocketFactory.StatusListener listener;
            private Consumer<String> receptionHandler;
            private boolean isOpen = false;
            private boolean isClosed = true;

            public void setStatusListener(WebsocketFactory.StatusListener listener) {
                this.listener = listener;
            }

            public void setReceptionHander(Consumer<String> receptionHandler) {
                this.receptionHandler = receptionHandler;
            }

            public void send(String text) throws IOException {
                if (null != this.receptionHandler) {
                    this.receptionHandler.accept(text);
                }
            }

            public boolean connectBlocking() throws IOException {
                if (null != this.listener) {
                    this.listener.onConnect();
                }
                this.isOpen = true;
                this.isClosed = false;
                return true;
            }

            public void connect() throws IOException {
                if (null != this.listener) {
                    this.listener.onConnect();
                }
                this.isOpen = true;
                this.isClosed = false;
            }

            public void close() throws IOException {
                if (null != this.listener) {
                    this.listener.onClose("close", false);
                }
                this.isOpen = false;
                this.isClosed = true;
            }

            public void closeBocking() throws IOException {
                if (null != this.listener) {
                    this.listener.onClose("closeBlocking", false);
                }
                this.isOpen = false;
                this.isClosed = true;
            }

            public URI getURI() {
                return uri;
            }

            public boolean isOpen() {
                return this.isOpen;
            }

            public boolean isClosed() {
                return this.isClosed;
            }
        };
    }

    public Server createBroadcastingServer(ServerAddress address) throws IOException {
        return new Server(){

            public void stop(boolean dispose) {
            }

            public Server start() {
                return this;
            }
        };
    }
}

