/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.collector.Collector;
import de.iip_ecosphere.platform.support.collector.CollectorSetup;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class CollectorTest {
    @Test
    public void testCollector() throws IOException {
        CollectorSetup setup = new CollectorSetup();
        CollectorSetup orig = Collector.setSetup((CollectorSetup)setup);
        Collector.Field[] origFields = Collector.getFields();
        Collector.collect((String)"tag").addExecutionTimeMs(1000L).close();
        System.setProperty("iip.ciBuildId", "9999");
        File tmp = FileUtils.getTempDirectory();
        File tagFile = new File(tmp, "tag.csv");
        FileUtils.deleteQuietly((File)tagFile);
        setup.setDataDir(FileUtils.getTempDirectoryPath());
        Collector.setSetup((CollectorSetup)setup);
        Collector.collect((String)"tag").measureMs(() -> TimeUtils.sleep((int)1000)).close();
        Assert.assertTrue((boolean)tagFile.exists());
        String tagFileContents = FileUtils.readFileToString((File)tagFile, (Charset)Charset.defaultCharset());
        String[] tagFileLines = tagFileContents.split("\\r?\\n");
        Assert.assertEquals((long)2L, (long)tagFileLines.length);
        this.assertHeader(tagFileLines[0], origFields);
        Assert.assertTrue((boolean)tagFileLines[1].matches("^\\d+,\"9999\",\\d+$"));
        Collector.Field[] fields = new Collector.Field[origFields.length + 1];
        System.arraycopy(origFields, 0, fields, 0, origFields.length);
        fields[origFields.length] = new Collector.Field("myField", (Object)-1);
        Collector.setFields((Collector.Field[])fields);
        Collector.collect((String)"tag").measureMs(() -> TimeUtils.sleep((int)1000)).close();
        tagFileContents = FileUtils.readFileToString((File)tagFile, (Charset)Charset.defaultCharset());
        tagFileLines = tagFileContents.split("\\r?\\n");
        Assert.assertEquals((long)3L, (long)tagFileLines.length);
        this.assertHeader(tagFileLines[0], fields);
        Assert.assertTrue((boolean)tagFileLines[1].matches("^\\d+,\"9999\",\\d+,-1$"));
        Assert.assertTrue((boolean)tagFileLines[2].matches("^\\d+,\"9999\",\\d+,-1$"));
        Collector.setFields((Collector.Field[])origFields);
        FileUtils.deleteQuietly((File)tagFile);
        Collector.setSetup((CollectorSetup)orig);
    }

    private void assertHeader(String text, Collector.Field[] fields) {
        String[] line = text.split(",");
        Assert.assertEquals((long)fields.length, (long)line.length);
        for (int l = 0; l < line.length; ++l) {
            String e = line[l];
            if (e.startsWith("\"") && e.endsWith("\"")) {
                e = e.substring(1, e.length() - 1);
            }
            Assert.assertEquals((Object)e, (Object)fields[l].getName());
        }
    }
}

