/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.ExtensionBasedFileFormat;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class FileFormatTest {
    @Test
    public void testFileFormat() {
        ExtensionBasedFileFormat ff = new ExtensionBasedFileFormat("exe", "Executable", "Windows Executable");
        Assert.assertEquals((Object)"exe", (Object)ff.getExtension());
        Assert.assertEquals((Object)"Executable", (Object)ff.getName());
        Assert.assertEquals((Object)"Windows Executable", (Object)ff.getDescription());
        Assert.assertEquals((Object)"Executable (*.exe, Windows Executable)", (Object)ff.toString());
        Assert.assertFalse((boolean)ff.matches(new File("readme.txt")));
        Assert.assertTrue((boolean)ff.matches(new File("cmd.exe")));
        try {
            ff = new ExtensionBasedFileFormat(".exe", null, "Windows Executable");
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ff = new ExtensionBasedFileFormat(".exe", "", "Windows Executable");
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ff = new ExtensionBasedFileFormat(".exe", "Executable", "");
        Assert.assertEquals((Object)"exe", (Object)ff.getExtension());
        Assert.assertEquals((Object)"Executable", (Object)ff.getName());
        Assert.assertEquals((Object)"", (Object)ff.getDescription());
        Assert.assertEquals((Object)"Executable (*.exe)", (Object)ff.toString());
        Assert.assertFalse((boolean)ff.matches(new File("ls")));
        Assert.assertFalse((boolean)ff.matches(new File("readme.txt")));
        Assert.assertTrue((boolean)ff.matches(new File("cmd.exe")));
        ff = new ExtensionBasedFileFormat(".exe", "Executable", null);
        Assert.assertEquals((Object)"exe", (Object)ff.getExtension());
        Assert.assertEquals((Object)"Executable", (Object)ff.getName());
        Assert.assertEquals((Object)"", (Object)ff.getDescription());
        Assert.assertEquals((Object)"Executable (*.exe)", (Object)ff.toString());
        Assert.assertFalse((boolean)ff.matches(new File("ls")));
        Assert.assertFalse((boolean)ff.matches(new File("readme.txt")));
        Assert.assertTrue((boolean)ff.matches(new File("cmd.exe")));
        ff = new ExtensionBasedFileFormat("", "All", "All file formats");
        Assert.assertEquals((Object)"", (Object)ff.getExtension());
        Assert.assertEquals((Object)"All", (Object)ff.getName());
        Assert.assertEquals((Object)"All file formats", (Object)ff.getDescription());
        Assert.assertEquals((Object)"All (All file formats)", (Object)ff.toString());
        Assert.assertTrue((boolean)ff.matches(new File("ls")));
        Assert.assertTrue((boolean)ff.matches(new File("readme.txt")));
        Assert.assertTrue((boolean)ff.matches(new File("cmd.exe")));
    }
}

