/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Updater;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class UpdaterTest {
    @Test
    public void testPluginUpdate() {
        File pluginsFolder = FileUtils.createTmpFolder((String)"support.updater-test", (boolean)true);
        InputStream in = ResourceLoader.getResourceAsStream((String)"update/resolved-plugin", (ResourceResolver[])new ResourceResolver[0]);
        Updater.updatePluginsQuiet((InputStream)in, (File)pluginsFolder, (boolean)false);
        File expected = new File(pluginsFolder, "slf4j-api-1.7.25.jar");
        Assert.assertTrue((boolean)expected.exists());
        FileUtils.deleteQuietly((File)pluginsFolder);
    }

    @Test
    public void testClientUpdate() {
        File pluginsFolder = FileUtils.createTmpFolder((String)"support.updater-test", (boolean)true);
        InputStream in = ResourceLoader.getResourceAsStream((String)"update/resolved-client", (ResourceResolver[])new ResourceResolver[0]);
        Updater.updatePluginsQuiet((InputStream)in, (File)pluginsFolder, (boolean)false);
        Assert.assertTrue((boolean)new File(pluginsFolder, "support.log-slf4j-simple-0.7.1-SNAPSHOT").exists());
        Assert.assertTrue((boolean)new File(pluginsFolder, "target").exists());
        Assert.assertTrue((boolean)new File(pluginsFolder, ".metadata").exists());
        Assert.assertTrue((boolean)new File(pluginsFolder, "support.log-slf4j-simple2-0.7.1-SNAPSHOT").exists());
        FileUtils.deleteQuietly((File)pluginsFolder);
    }
}

