/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.generic;

import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericClient;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

public class GenericMessageProducer
extends MessageProducerSupport {
    private final ConsumerDestination destination;
    private GenericClient amqpClient;

    public GenericMessageProducer(ConsumerDestination destination, GenericClient amqpClient) {
        this.destination = destination;
        this.amqpClient = amqpClient;
    }

    public void doStart() {
        this.amqpClient.subscribeTo(this.destination.getName(), new Callback());
    }

    protected void doStop() {
        this.amqpClient.unsubscribeFrom(this.destination.getName());
    }

    private class Callback
    implements GenericClient.ArrivedCallback {
        private Callback() {
        }

        @Override
        public void messageArrived(String topic, byte[] payload) {
            Message msg = MessageBuilder.withPayload((Object)payload).build();
            GenericMessageProducer.this.sendMessage(msg);
        }
    }
}

