/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.generic;

import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.spring.BeanHelper;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericClient;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericConfiguration;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericMessageBinder;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericMessageBinderProvisioner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GenericConfiguration.class})
public class GenericMessageBinderConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GenericMessageBinderProvisioner genericBinderProvisioner(GenericClient amqpClient) {
        return new GenericMessageBinderProvisioner(amqpClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public GenericClient amqpClient() {
        return new GenericClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public GenericMessageBinder genericBinder(GenericMessageBinderProvisioner messageBinderProvisioner, GenericClient amqpClient) {
        return new GenericMessageBinder(null, messageBinderProvisioner, amqpClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public TransportParameter mqttTransportParameter(@Autowired ApplicationContext ctx, @Autowired GenericConfiguration config) {
        return (TransportParameter)BeanHelper.registerInParentContext((ApplicationContext)ctx, (Object)config.toTransportParameter(), (String)"amqp");
    }
}

