/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.generic;

import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericConfiguration;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericMessageBinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class GenericClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericMessageBinder.class);
    private static GenericClient lastInstance;
    private TransportConnector connector;
    private boolean globalInstance = false;
    private GenericConfiguration configuration;
    private Map<String, ReceptionCallback<?>> topics = Collections.synchronizedMap(new HashMap());

    public GenericClient() {
        lastInstance = this;
    }

    public static GenericClient getLastInstance() {
        return lastInstance;
    }

    public GenericConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized void createClient(GenericConfiguration config) {
        if (null == this.connector) {
            try {
                this.configuration = config;
                if (config.getHost() == null || config.getHost().trim().length() == 0) {
                    this.connector = Transport.getGlobalTransport().createConnector();
                    this.globalInstance = true;
                } else {
                    this.connector = TransportFactory.createConnector();
                    LOGGER.info("Generic: Connecting to " + config.getHost() + " " + config.getPort());
                    TransportParameter.TransportParameterBuilder pBuilder = TransportParameter.TransportParameterBuilder.newBuilder((String)config.getHost(), (int)config.getPort()).setHostnameVerification(config.getHostnameVerification()).setAuthenticationKey(config.getAuthenticationKey());
                    if (config.useTls()) {
                        pBuilder.setKeystoreKey(config.getKeystoreKey());
                    }
                    this.connector.connect(pBuilder.build());
                    this.globalInstance = false;
                }
            }
            catch (IOException e) {
                LOGGER.error("Creating generic client: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stopClient() {
        try {
            ArrayList<String> tpcs = new ArrayList<String>(this.topics.keySet());
            for (String t : tpcs) {
                this.unsubscribeFrom(t);
            }
            if (!this.globalInstance) {
                this.connector.disconnect();
            }
            this.topics.clear();
            this.connector = null;
        }
        catch (IOException e) {
            LOGGER.error("Stopping generic client: " + e.getMessage(), (Throwable)e);
        }
    }

    boolean subscribeTo(final String topic, final ArrivedCallback arrivedCallback) {
        boolean done = false;
        if (!this.configuration.isFilteredTopic(topic) && null != this.connector) {
            try {
                ReceptionCallback<byte[]> callback = new ReceptionCallback<byte[]>(){

                    public void received(byte[] data) {
                        arrivedCallback.messageArrived(topic, data);
                    }

                    public Class<byte[]> getType() {
                        return byte[].class;
                    }
                };
                this.connector.setReceptionCallback(topic, (ReceptionCallback)callback);
                this.topics.put(topic, callback);
                LOGGER.info("Subscribed to " + topic);
                done = true;
            }
            catch (IOException e) {
                LOGGER.error("Subscribing to AMQP broker: " + e.getMessage(), (Throwable)e);
            }
        }
        return done;
    }

    boolean unsubscribeFrom(String topic) {
        ReceptionCallback<?> callback;
        boolean done = false;
        if (null != this.connector && !this.configuration.isFilteredTopic(topic) && (callback = this.topics.remove(topic)) != null) {
            try {
                this.connector.detachReceptionCallback(topic, callback);
                LOGGER.info("Unsubscribed from {}", (Object)topic);
            }
            catch (IOException e) {
                LOGGER.error("Unsubscribing from {}: {}", new Object[]{topic, e.getMessage(), e});
            }
        }
        return done;
    }

    void send(String topic, byte[] payload) {
        if (null != this.connector) {
            try {
                this.connector.asyncSend(topic, (Object)payload);
            }
            catch (IOException e) {
                LOGGER.error("Sending generic: " + e.getMessage());
            }
        }
    }

    public static interface ArrivedCallback {
        public void messageArrived(String var1, byte[] var2);
    }
}

