/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import org.springframework.integration.handler.MessageHandlerSupport;
import org.springframework.integration.history.MessageHistory;
import org.springframework.messaging.Message;
import org.springframework.messaging.ReactiveMessageHandler;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveMessageHandler
extends MessageHandlerSupport
implements ReactiveMessageHandler {
    public Mono<Void> handleMessage(Message<?> message) {
        Assert.notNull(message, (String)"message must not be null");
        if (this.isLoggingEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)(this + " received message: " + message));
        }
        Message<?> messageToUse = this.shouldTrack() ? MessageHistory.write(message, this, this.getMessageBuilderFactory()) : message;
        return this.handleMessageInternal(messageToUse).doOnError(ex -> this.logger.error(ex, () -> "An error occurred in message handler [" + this + "] on message [" + messageToUse + "]"));
    }

    protected abstract Mono<Void> handleMessageInternal(Message<?> var1);
}

