/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.spring.binder.generic;

import com.rabbitmq.client.ConnectionFactory;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.connectors.rabbitmq.RabbitMqAmqpTransportConnector;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericClient;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.MimeType;
import test.de.iip_ecosphere.platform.test.amqp.qpid.TestQpidServer;
import test.de.iip_ecosphere.platform.transport.spring.StringSerializer;

@SpringBootTest
@TestPropertySource(locations={"classpath:test.properties"})
@ContextConfiguration(initializers={Initializer.class})
@RunWith(value=SpringRunner.class)
public class GenericMessageBinderTest {
    private static ServerAddress addr = new ServerAddress(Schema.IGNORE);
    private static TestQpidServer server;
    private static String received;
    private static File secCfg;
    private static boolean relyOnGlobal;
    @Autowired
    private TransportParameter params;

    protected static void setSecCfg(File folder) {
        secCfg = folder;
    }

    protected static void setRelyOnGlobal(boolean global) {
        relyOnGlobal = global;
    }

    protected static String getKeystoreKey() {
        return null == secCfg ? null : "amqpKeyStore";
    }

    protected static ServerAddress resetAddr() {
        received = null;
        addr = new ServerAddress(Schema.IGNORE);
        return addr;
    }

    @BeforeClass
    public static void init() {
        TestQpidServer.setConfigDir((File)secCfg);
        server = new TestQpidServer(addr);
        server.start();
        TimeUtils.sleep((int)1000);
        SerializerRegistry.registerSerializer(StringSerializer.class);
        if (relyOnGlobal) {
            TransportSetup setup = new TransportSetup();
            setup.setHost(addr.getHost());
            setup.setPort(addr.getPort());
            setup.setAuthenticationKey("amqp");
            Transport.getGlobalTransport().setTransportSetup(() -> setup);
        }
        final RabbitMqAmqpTransportConnector infra = new RabbitMqAmqpTransportConnector(){

            protected void configureFactory(ConnectionFactory factory) {
                factory.setUsername("user");
                factory.setPassword("pwd");
            }
        };
        try {
            TransportParameter.TransportParameterBuilder tpBuilder = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setApplicationId("infra");
            if (null != secCfg) {
                tpBuilder.setKeystoreKey(GenericMessageBinderTest.getKeystoreKey());
            }
            infra.connect(tpBuilder.build());
            infra.setReceptionCallback("genericBinder", (ReceptionCallback)new ReceptionCallback<String>(){

                public void received(String data) {
                    try {
                        infra.asyncSend("input2", (Object)("config " + data));
                    }
                    catch (IOException e) {
                        System.out.println("SEND PROBLEM " + e.getMessage());
                    }
                }

                public Class<String> getType() {
                    return String.class;
                }
            });
        }
        catch (IOException e) {
            Assert.fail((String)("CONNECTOR PROBLEM " + e.getMessage()));
        }
        System.out.println("Started infra client on " + addr.getHost() + " " + addr.getPort());
        TimeUtils.sleep((int)1000);
    }

    @AfterClass
    public static void shutdown() {
        if (null != GenericClient.getLastInstance()) {
            GenericClient.getLastInstance().stopClient();
        }
        server.stop(true);
        SerializerRegistry.unregisterSerializer(StringSerializer.class);
        SerializerRegistry.resetDefaults();
        TestQpidServer.setConfigDir(null);
    }

    @Test
    public void testMessages() {
        TimeUtils.sleep((int)2000);
        Assert.assertEquals((String)"Received value on configuration stream does not match", (Object)"config DMG-1 world", (Object)received);
        Assert.assertNotNull((String)"The autowired transport parameters shall not be null", (Object)this.params);
        if (!relyOnGlobal) {
            Assert.assertEquals((Object)"localhost", (Object)this.params.getHost());
        }
        Assert.assertEquals((Object)"", (Object)this.params.getApplicationId());
    }

    static {
        relyOnGlobal = false;
    }

    @SpringBootApplication
    public static class MyProcessor {
        @Bean
        public Supplier<String> in() {
            return () -> "DMG-1";
        }

        @Bean
        public Function<String, String> transform() {
            return in -> in + " world";
        }

        @Bean
        public Consumer<String> receiveInput() {
            return s -> {
                received = s;
            };
        }

        @Bean
        public MessageConverter customMessageConverter() {
            return new SerializerMessageConverter(new MimeType("application", "ser-string"));
        }
    }

    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
            if (relyOnGlobal) {
                TestPropertyValues.of((String[])new String[]{"generic.host="}).applyTo(applicationContext);
            }
            TestPropertyValues.of((String[])new String[]{"generic.port=" + addr.getPort()}).applyTo(applicationContext);
            if (null == GenericClient.getLastInstance() && null != GenericMessageBinderTest.getKeystoreKey()) {
                TestPropertyValues.of((String[])new String[]{"generic.keystoreKey=" + GenericMessageBinderTest.getKeystoreKey()}).applyTo(applicationContext);
            }
        }
    }
}

