/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.generic;

import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericClient;
import de.iip_ecosphere.platform.transport.spring.binder.generic.GenericConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.stereotype.Component;

@Component
public class GenericMessageBinderProvisioner
implements ProvisioningProvider<ConsumerProperties, ProducerProperties> {
    @Autowired
    private GenericConfiguration options;
    private GenericClient client;

    public GenericMessageBinderProvisioner(GenericClient amqpClient) {
        this.client = amqpClient;
    }

    public ProducerDestination provisionProducerDestination(String name, ProducerProperties properties) throws ProvisioningException {
        this.client.createClient(this.options);
        return new GenericMessageDestination(name);
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ConsumerProperties properties) throws ProvisioningException {
        this.client.createClient(this.options);
        return new GenericMessageDestination(name);
    }

    private class GenericMessageDestination
    implements ProducerDestination,
    ConsumerDestination {
        private final String destination;

        private GenericMessageDestination(String destination) {
            this.destination = destination;
        }

        public String getName() {
            return this.destination.trim();
        }

        public String getNameForPartition(int partition) {
            throw new UnsupportedOperationException("Partitioning is not implemented.");
        }
    }
}

