/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.cloudevent;

import java.lang.reflect.Field;
import java.net.URI;
import java.time.OffsetTime;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.function.cloudevent.CloudEventMessageBuilder;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class CloudEventMessageUtils {
    private static final ContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver(){

        public MimeType resolve(@Nullable MessageHeaders headers) {
            if (headers.containsKey((Object)"content-type")) {
                return MimeType.valueOf((String)headers.get((Object)"content-type").toString());
            }
            return super.resolve(headers);
        }
    };
    private static Field MESSAGE_HEADERS = ReflectionUtils.findField(MessageHeaders.class, (String)"headers");
    static String _DATA;
    static String _ID;
    static String _SOURCE;
    static String _SPECVERSION;
    static String _TYPE;
    static String _DATACONTENTTYPE;
    static String _DATASCHEMA;
    static String _SCHEMAURL;
    static String _SUBJECT;
    static String _TIME;
    public static String CLOUDEVENT_VALUE;
    public static String APPLICATION_CLOUDEVENTS_VALUE;
    public static MimeType APPLICATION_CLOUDEVENTS;
    public static String DEFAULT_ATTR_PREFIX;
    public static String AMQP_ATTR_PREFIX;
    public static String KAFKA_ATTR_PREFIX;
    public static String DATA;
    public static String ID;
    public static String SOURCE;
    public static String SPECVERSION;
    public static String TYPE;
    public static String DATACONTENTTYPE;
    public static String DATASCHEMA;
    public static final String SCHEMAURL;
    public static String SUBJECT;
    public static String TIME;

    private CloudEventMessageUtils() {
    }

    public static String getId(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return (String)message.getHeaders().get((Object)(prefix + "id"));
    }

    public static URI getSource(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return CloudEventMessageUtils.safeGetURI((Map<String, Object>)message.getHeaders(), prefix + _SOURCE);
    }

    public static String getSpecVersion(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return (String)message.getHeaders().get((Object)(prefix + _SPECVERSION));
    }

    public static String getType(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return (String)message.getHeaders().get((Object)(prefix + _TYPE));
    }

    public static String getDataContentType(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return (String)message.getHeaders().get((Object)(prefix + _DATACONTENTTYPE));
    }

    public static URI getDataSchema(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return CloudEventMessageUtils.safeGetURI((Map<String, Object>)message.getHeaders(), prefix + _DATASCHEMA);
    }

    public static String getSubject(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return (String)message.getHeaders().get((Object)(prefix + _SUBJECT));
    }

    public static OffsetTime getTime(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return (OffsetTime)message.getHeaders().get((Object)(prefix + _TIME));
    }

    public static <T> T getData(Message<?> message) {
        return (T)message.getPayload();
    }

    public static Map<String, Object> getAttributes(Message<?> message) {
        return message.getHeaders().entrySet().stream().filter(e -> CloudEventMessageUtils.isAttribute((String)e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    static Message<?> toCanonical(Message<?> inputMessage, MessageConverter messageConverter) {
        Map headers = (Map)ReflectionUtils.getField((Field)MESSAGE_HEADERS, (Object)inputMessage.getHeaders());
        CloudEventMessageUtils.canonicalizeHeaders(headers, false);
        String inputContentType = (String)inputMessage.getHeaders().get((Object)DATACONTENTTYPE);
        if (!CloudEventMessageUtils.isCloudEvent(inputMessage) && headers.containsKey("contentType")) {
            MimeType contentType = contentTypeResolver.resolve(inputMessage.getHeaders());
            if (contentType.getType().equals(APPLICATION_CLOUDEVENTS.getType()) && contentType.getSubtype().startsWith(APPLICATION_CLOUDEVENTS.getSubtype())) {
                String dataContentType = StringUtils.hasText((String)inputContentType) ? inputContentType : "application/json";
                String suffix = contentType.getSubtypeSuffix() == null ? "json" : contentType.getSubtypeSuffix();
                MimeType cloudEventDeserializationContentType = MimeTypeUtils.parseMimeType((String)(contentType.getType() + "/" + suffix));
                Message cloudEventMessage = MessageBuilder.fromMessage(inputMessage).setHeader("contentType", (Object)cloudEventDeserializationContentType).setHeader(DATACONTENTTYPE, (Object)dataContentType).build();
                Map structuredCloudEvent = (Map)messageConverter.fromMessage(cloudEventMessage, Map.class);
                CloudEventMessageUtils.canonicalizeHeaders(structuredCloudEvent, true);
                return CloudEventMessageUtils.buildBinaryMessageFromStructuredMap(structuredCloudEvent, inputMessage.getHeaders());
            }
        } else if (StringUtils.hasText((String)inputContentType)) {
            return MessageBuilder.fromMessage(inputMessage).setHeader("contentType", (Object)inputContentType).build();
        }
        return inputMessage;
    }

    static String determinePrefixToUse(Map<String, Object> messageHeaders) {
        String targetProtocol = (String)messageHeaders.get(MessageUtils.TARGET_PROTOCOL);
        String prefix = CloudEventMessageUtils.determinePrefixToUse(targetProtocol);
        if (StringUtils.hasText((String)prefix)) {
            return prefix;
        }
        for (String key : messageHeaders.keySet()) {
            if (key.startsWith(DEFAULT_ATTR_PREFIX)) {
                return DEFAULT_ATTR_PREFIX;
            }
            if (key.startsWith(KAFKA_ATTR_PREFIX)) {
                return KAFKA_ATTR_PREFIX;
            }
            if (!key.startsWith(AMQP_ATTR_PREFIX)) continue;
            return AMQP_ATTR_PREFIX;
        }
        return "";
    }

    static String determinePrefixToUse(String targetProtocol) {
        if (StringUtils.hasText((String)targetProtocol)) {
            if (Protocols.KAFKA.equals(targetProtocol)) {
                return KAFKA_ATTR_PREFIX;
            }
            if (Protocols.AMQP.equals(targetProtocol)) {
                return AMQP_ATTR_PREFIX;
            }
            if (Protocols.HTTP.equals(targetProtocol)) {
                return DEFAULT_ATTR_PREFIX;
            }
        }
        return "";
    }

    public static boolean isCloudEvent(Message<?> message) {
        return message.getHeaders().containsKey((Object)SPECVERSION) && message.getHeaders().containsKey((Object)TYPE) && message.getHeaders().containsKey((Object)SOURCE) || message.getHeaders().containsKey((Object)_SPECVERSION) && message.getHeaders().containsKey((Object)_TYPE) && message.getHeaders().containsKey((Object)_SOURCE) || message.getHeaders().containsKey((Object)(AMQP_ATTR_PREFIX + _SPECVERSION)) && message.getHeaders().containsKey((Object)(AMQP_ATTR_PREFIX + _TYPE)) && message.getHeaders().containsKey((Object)(AMQP_ATTR_PREFIX + _SOURCE)) || message.getHeaders().containsKey((Object)(KAFKA_ATTR_PREFIX + _SPECVERSION)) && message.getHeaders().containsKey((Object)(KAFKA_ATTR_PREFIX + _TYPE)) && message.getHeaders().containsKey((Object)(KAFKA_ATTR_PREFIX + _SOURCE));
    }

    private static boolean isAttribute(String key) {
        return key.startsWith(DEFAULT_ATTR_PREFIX) || key.startsWith(AMQP_ATTR_PREFIX) || key.startsWith(KAFKA_ATTR_PREFIX);
    }

    private static void canonicalizeHeaders(Map<String, Object> headers, boolean structured) {
        String[] keys;
        for (String key : keys = headers.keySet().toArray(new String[0])) {
            Object value;
            if (key.startsWith(DEFAULT_ATTR_PREFIX)) {
                value = headers.remove(key);
                key = key.substring(DEFAULT_ATTR_PREFIX.length());
                headers.put(DEFAULT_ATTR_PREFIX + key, value);
                continue;
            }
            if (key.startsWith(KAFKA_ATTR_PREFIX)) {
                value = headers.remove(key);
                key = key.substring(KAFKA_ATTR_PREFIX.length());
                headers.put(DEFAULT_ATTR_PREFIX + key, value);
                continue;
            }
            if (key.startsWith(AMQP_ATTR_PREFIX)) {
                value = headers.remove(key);
                key = key.substring(AMQP_ATTR_PREFIX.length());
                headers.put(DEFAULT_ATTR_PREFIX + key, value);
                continue;
            }
            if (!structured) continue;
            value = headers.remove(key);
            headers.put(DEFAULT_ATTR_PREFIX + key, value);
        }
    }

    private static Message<?> buildBinaryMessageFromStructuredMap(Map<String, Object> structuredCloudEvent, MessageHeaders originalHeaders) {
        Map payload = structuredCloudEvent.remove(DATA);
        if (payload == null) {
            payload = Collections.emptyMap();
        }
        CloudEventMessageBuilder messageBuilder = CloudEventMessageBuilder.withData(payload).copyHeaders(structuredCloudEvent);
        for (String key : originalHeaders.keySet()) {
            if ("id".equals(key)) continue;
            messageBuilder.setHeader(key, originalHeaders.get((Object)key));
        }
        return messageBuilder.build();
    }

    private static URI safeGetURI(Map<String, Object> map, String key) {
        Object uri = map.get(key);
        if (uri != null && uri instanceof String) {
            uri = URI.create((String)uri);
        }
        return (URI)uri;
    }

    static {
        MESSAGE_HEADERS.setAccessible(true);
        _DATA = "data";
        _ID = "id";
        _SOURCE = "source";
        _SPECVERSION = "specversion";
        _TYPE = "type";
        _DATACONTENTTYPE = "datacontenttype";
        _DATASCHEMA = "dataschema";
        _SCHEMAURL = "schemaurl";
        _SUBJECT = "subject";
        _TIME = "time";
        CLOUDEVENT_VALUE = "cloudevent";
        APPLICATION_CLOUDEVENTS_VALUE = "application/cloudevents";
        APPLICATION_CLOUDEVENTS = MimeTypeUtils.parseMimeType((String)APPLICATION_CLOUDEVENTS_VALUE);
        DEFAULT_ATTR_PREFIX = "ce-";
        AMQP_ATTR_PREFIX = "cloudEvents:";
        KAFKA_ATTR_PREFIX = "ce_";
        DATA = DEFAULT_ATTR_PREFIX + _DATA;
        ID = DEFAULT_ATTR_PREFIX + _ID;
        SOURCE = DEFAULT_ATTR_PREFIX + _SOURCE;
        SPECVERSION = DEFAULT_ATTR_PREFIX + _SPECVERSION;
        TYPE = DEFAULT_ATTR_PREFIX + _TYPE;
        DATACONTENTTYPE = DEFAULT_ATTR_PREFIX + _DATACONTENTTYPE;
        DATASCHEMA = DEFAULT_ATTR_PREFIX + _DATASCHEMA;
        SCHEMAURL = DEFAULT_ATTR_PREFIX + _SCHEMAURL;
        SUBJECT = DEFAULT_ATTR_PREFIX + _SUBJECT;
        TIME = DEFAULT_ATTR_PREFIX + _TIME;
    }

    public static class Protocols {
        static String AMQP = "amqp";
        static String AVRO = "avro";
        static String HTTP = "http";
        static String JSON = "json";
        static String KAFKA = "kafka";
    }
}

