/**
 * ******************************************************************************
 * Copyright (c) {2025} The original author or authors
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License 2.0 which is available 
 * at http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: Apache-2.0 OR EPL-2.0
 ********************************************************************************/

package test.de.iip_ecosphere.platform.transport.spring.binder.generic;

import org.junit.AfterClass;
import org.junit.BeforeClass;

/**
 * Runs {@link GenericMessageBinderTest} with TLS.
 * 
 * @author Holger Eichelberger, SSE
 */
public class GenericMessageBinderGlobalTest extends GenericMessageBinderTest {

    /**
     * Initializes the test for global transport.
     */
    @BeforeClass
    public static void init() {
        setRelyOnGlobal(true);
        GenericMessageBinderTest.init();
    }
    
    /**
     * Resets global transport.
     */
    @AfterClass
    public static void shutdown() {
        GenericMessageBinderTest.shutdown();
        setRelyOnGlobal(false);
    }
    
}
