/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.hivemqv3;

import de.iip_ecosphere.platform.transport.spring.binder.hivemqv3.HivemqV3Client;
import de.iip_ecosphere.platform.transport.spring.binder.hivemqv3.HivemqV3Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.stereotype.Component;

@Component
public class HivemqV3MessageBinderProvisioner
implements ProvisioningProvider<ConsumerProperties, ProducerProperties> {
    @Autowired
    private HivemqV3Configuration options;
    private HivemqV3Client client;

    public HivemqV3MessageBinderProvisioner(HivemqV3Client client) {
        this.client = client;
    }

    public ProducerDestination provisionProducerDestination(String name, ProducerProperties properties) throws ProvisioningException {
        this.client.createClient(this.options);
        return new MqttMessageDestination(name);
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ConsumerProperties properties) throws ProvisioningException {
        this.client.createClient(this.options);
        return new MqttMessageDestination(name);
    }

    private class MqttMessageDestination
    implements ProducerDestination,
    ConsumerDestination {
        private final String destination;

        private MqttMessageDestination(String destination) {
            this.destination = destination;
        }

        public String getName() {
            return this.destination.trim();
        }

        public String getNameForPartition(int partition) {
            throw new UnsupportedOperationException("Partitioning is not implemented.");
        }
    }
}

