/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.hivemqv3;

import com.hivemq.client.mqtt.datatypes.MqttQos;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.spring.BasicConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="mqtt")
public class HivemqV3Configuration
extends BasicConfiguration {
    private String clientId;
    private boolean autoClientId = true;
    private int keepAlive = 60000;
    private List<String> filteredTopics = new ArrayList<String>();
    private String qos = MqttQos.AT_LEAST_ONCE.name();

    public boolean isFilteredTopic(String topic) {
        return this.filteredTopics.contains(topic);
    }

    public List<String> getFilteredTopics() {
        return this.filteredTopics;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean getAutoClientId() {
        return this.autoClientId;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public MqttQos getQos() {
        return MqttQos.valueOf((String)this.qos);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAutoClientId(boolean autoClientId) {
        this.autoClientId = autoClientId;
    }

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setFilteredTopics(List<String> filteredTopics) {
        this.filteredTopics = filteredTopics;
    }

    public void setQos(String qos) {
        try {
            MqttQos.valueOf((String)qos.toUpperCase());
            this.qos = qos.toUpperCase();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public TransportParameter toTransportParameter() {
        return this.createTransportParameterBuilder().setApplicationId(this.getClientId()).setAutoApplicationId(this.getAutoClientId()).setKeepAlive(this.getKeepAlive()).build();
    }
}

