/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.metrics.buffering;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.metrics.buffering.BufferedStartupStep;
import org.springframework.core.metrics.StartupStep;

public class StartupTimeline {
    private final Instant startTime;
    private final List<TimelineEvent> events;

    StartupTimeline(Instant startTime, long startNanoTime, Collection<BufferedStartupStep> events) {
        this.startTime = startTime;
        this.events = events.stream().map(event -> new TimelineEvent((BufferedStartupStep)event, startTime, startNanoTime)).collect(Collectors.toList());
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public List<TimelineEvent> getEvents() {
        return this.events;
    }

    public static class TimelineEvent {
        private final StartupStep startupStep;
        private final Instant startTime;
        private final Instant endTime;
        private final Duration duration;

        TimelineEvent(BufferedStartupStep startupStep, Instant startupDate, long startupNanoTime) {
            this.startupStep = startupStep;
            this.startTime = startupDate.plus(Duration.ofNanos(startupStep.getStartTime() - startupNanoTime));
            this.endTime = startupDate.plus(Duration.ofNanos(startupStep.getEndTime() - startupNanoTime));
            this.duration = Duration.ofNanos(startupStep.getEndTime() - startupStep.getStartTime());
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public Instant getEndTime() {
            return this.endTime;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public StartupStep getStartupStep() {
            return this.startupStep;
        }
    }
}

