/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.cloudevent;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.BeansException;
import org.springframework.cloud.function.cloudevent.CloudEventHeaderEnricher;
import org.springframework.cloud.function.cloudevent.CloudEventMessageBuilder;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.cloud.function.core.FunctionInvocationHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.StringUtils;

class CloudEventsFunctionInvocationHelper
implements FunctionInvocationHelper<Message<?>>,
ApplicationContextAware {
    private ConfigurableApplicationContext applicationContext;
    private final CloudEventHeaderEnricher cloudEventAttributesProvider;

    CloudEventsFunctionInvocationHelper(@Nullable CloudEventHeaderEnricher cloudEventHeadersProvider) {
        this.cloudEventAttributesProvider = cloudEventHeadersProvider;
    }

    public boolean isRetainOuputAsMessage(Message<?> message) {
        return message.getHeaders().containsKey((Object)MessageUtils.TARGET_PROTOCOL) || message.getHeaders().containsKey((Object)MessageUtils.MESSAGE_TYPE) && message.getHeaders().get((Object)MessageUtils.MESSAGE_TYPE).equals(CloudEventMessageUtils.CLOUDEVENT_VALUE);
    }

    public Message<?> preProcessInput(Message<?> input, Object inputConverter) {
        try {
            return CloudEventMessageUtils.toCanonical(input, (MessageConverter)inputConverter);
        }
        catch (Exception e) {
            return input;
        }
    }

    public Message<?> postProcessResult(Object result, Message<?> input) {
        String targetPrefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)input.getHeaders());
        return this.doPostProcessResult(result, targetPrefix);
    }

    public Message<?> postProcessResult(Object result, String targetProtocol) {
        String targetPrefix = CloudEventMessageUtils.determinePrefixToUse(targetProtocol);
        return this.doPostProcessResult(result, targetPrefix);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Message<?> doPostProcessResult(Object result, String targetPrefix) {
        void var4_6;
        void var4_8;
        Message resultMessage = null;
        if (result instanceof Message) {
            if (!CloudEventMessageUtils.isCloudEvent((Message)result)) return (Message)result;
            CloudEventMessageBuilder cloudEventMessageBuilder = CloudEventMessageBuilder.fromMessage((Message)result);
        } else {
            CloudEventMessageBuilder<Object> cloudEventMessageBuilder = CloudEventMessageBuilder.withData(result).setId(UUID.randomUUID().toString()).setSource(URI.create("http://spring.io/" + this.getApplicationName())).setType(result.getClass().getName());
        }
        if (this.cloudEventAttributesProvider == null) return var4_8.build(targetPrefix);
        CloudEventMessageBuilder<?> cloudEventMessageBuilder = this.cloudEventAttributesProvider.enrich((CloudEventMessageBuilder<?>)var4_6);
        return var4_8.build(targetPrefix);
    }

    private String getApplicationName() {
        ConfigurableEnvironment environment = this.applicationContext.getEnvironment();
        String name = environment.getProperty("spring.application.name");
        return StringUtils.hasText((String)name) ? name : "";
    }
}

