/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.transport.spring.BinderFixProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderCustomizer;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class BinderFix {
    @Autowired(required=false)
    private Collection<DefaultBinderFactory.Listener> binderFactoryListeners;
    @Autowired
    private BinderFixProperties properties;
    @Value(value="spring.cloud.stream.defaultBinder:")
    private String defaultBinder;

    @Bean
    public BinderFactory binderFactory(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties) {
        BinderCustomizer binderCustomizer = null;
        DefaultBinderFactory binderFactory = new DefaultBinderFactory(BinderFix.getBinderConfigurations(binderTypeRegistry, bindingServiceProperties, this.defaultBinder, this.properties), binderTypeRegistry, binderCustomizer){

            public synchronized <T> Binder<T, ?, ?> getBinder(String name, Class<? extends T> bindingTargetType) {
                Binder binder = super.getBinder(name, bindingTargetType);
                return binder;
            }
        };
        binderFactory.setDefaultBinder(bindingServiceProperties.getDefaultBinder());
        binderFactory.setListeners(this.binderFactoryListeners);
        return binderFactory;
    }

    private static Map<String, BinderConfiguration> getBinderConfigurations(BinderTypeRegistry binderTypeRegistry, BindingServiceProperties bindingServiceProperties, String defaultBinder, BinderFixProperties properties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map declaredBinders = bindingServiceProperties.getBinders();
        boolean defaultCandidatesExist = false;
        Iterator binderPropertiesIterator = declaredBinders.entrySet().iterator();
        while (!defaultCandidatesExist && binderPropertiesIterator.hasNext()) {
            defaultCandidatesExist = ((BinderProperties)binderPropertiesIterator.next().getValue()).isDefaultCandidate();
        }
        ArrayList<String> existingBinderConfigurations = new ArrayList<String>();
        for (Map.Entry binderEntry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = (BinderProperties)binderEntry.getValue();
            if (binderTypeRegistry.get((String)binderEntry.getKey()) != null) {
                binderConfigurations.put((String)binderEntry.getKey(), new BinderConfiguration((String)binderEntry.getKey(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
                existingBinderConfigurations.add((String)binderEntry.getKey());
                continue;
            }
            BinderProperties binderProp = binderProperties;
            String type = binderProperties.getType();
            if (null == type) {
                if (null != properties && null != properties.getProperties()) {
                    binderProp = properties.getProperties().get(binderEntry.getKey());
                    type = binderProp.getType();
                }
                if (null == type) {
                    type = defaultBinder;
                }
            }
            Assert.hasText((String)type, (String)("No 'type' property present for custom binder " + (String)binderEntry.getKey()));
            binderConfigurations.put((String)binderEntry.getKey(), new BinderConfiguration(type, binderProp.getEnvironment(), binderProp.isInheritEnvironment(), binderProp.isDefaultCandidate()));
            existingBinderConfigurations.add((String)binderEntry.getKey());
        }
        for (Map.Entry configurationEntry : binderConfigurations.entrySet()) {
            if (!((BinderConfiguration)configurationEntry.getValue()).isDefaultCandidate()) continue;
            defaultCandidatesExist = true;
        }
        if (!defaultCandidatesExist) {
            for (Map.Entry binderEntry : binderTypeRegistry.getAll().entrySet()) {
                if (existingBinderConfigurations.contains(binderEntry.getKey())) continue;
                binderConfigurations.put((String)binderEntry.getKey(), new BinderConfiguration((String)binderEntry.getKey(), new HashMap(), true, !"integration".equals(binderEntry.getKey())));
            }
        }
        return binderConfigurations;
    }
}

