/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.hivemqv5;

import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5UnsubscribeBuilder;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.impl.AbstractTransportConnector;
import de.iip_ecosphere.platform.transport.spring.binder.hivemqv5.HivemqV5Configuration;
import de.iip_ecosphere.platform.transport.spring.binder.hivemqv5.HivemqV5MessageBinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.springframework.stereotype.Component;

@Component
public class HivemqV5Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(HivemqV5MessageBinder.class);
    private static HivemqV5Client lastInstance;
    private Mqtt5AsyncClient client;
    private HivemqV5Configuration configuration;
    private MqttQos qos = MqttQos.AT_LEAST_ONCE;
    private Set<String> topics = new HashSet<String>();

    public HivemqV5Client() {
        lastInstance = this;
    }

    public static HivemqV5Client getLastInstance() {
        return lastInstance;
    }

    public HivemqV5Configuration getConfiguration() {
        return this.configuration;
    }

    public synchronized void createClient(HivemqV5Configuration config) {
        if (null == this.client) {
            this.configuration = config;
            this.qos = config.getQos();
            String clientId = AbstractTransportConnector.getApplicationId((String)config.getClientId(), (String)"stream", (boolean)config.getAutoClientId());
            LOGGER.info("Connecting to " + config.getPort() + "@" + config.getHost() + " with client id " + clientId);
            Mqtt5ClientBuilder builder = (Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)MqttClient.builder().useMqttVersion5().identifier(clientId)).serverHost(config.getHost())).serverPort(config.getPort())).automaticReconnect().applyAutomaticReconnect();
            AbstractTransportConnector.applyAuthenticationKey((String)config.getAuthenticationKey(), (user, pwd, enc) -> {
                ((Mqtt5SimpleAuthBuilder.Nested.Complete)((Mqtt5SimpleAuthBuilder.Nested.Complete)builder.simpleAuth().username(user)).password(pwd.getBytes())).applySimpleAuth();
                return true;
            });
            if (config.useTls()) {
                try {
                    HostnameVerifier verifier = null;
                    if (!config.getHostnameVerification()) {
                        verifier = new HostnameVerifier(){

                            @Override
                            public boolean verify(String hostname, SSLSession session) {
                                return true;
                            }
                        };
                    }
                    MqttClientSslConfig sslConfig = ((MqttClientSslConfigBuilder)((MqttClientSslConfigBuilder)MqttClientSslConfig.builder().trustManagerFactory(config.createTrustManagerFactory())).hostnameVerifier(verifier)).build();
                    builder.sslConfig(sslConfig);
                }
                catch (IOException e) {
                    LOGGER.info("SSL config error: " + e.getMessage() + " Trying without TLS.");
                }
            }
            Mqtt5AsyncClient cl = builder.buildAsync();
            ((CompletableFuture)((CompletableFuture)((Mqtt5ConnectBuilder.Send)((Mqtt5ConnectBuilder.Send)cl.connectWith().cleanStart(false)).keepAlive(config.getKeepAlive())).send()).whenComplete((connAck, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Connecting MQTT client: " + throwable.getMessage(), throwable);
                } else {
                    this.client = cl;
                }
            })).join();
        }
    }

    public void stopClient() {
        if (null != this.client) {
            ArrayList<String> tpcs = new ArrayList<String>(this.topics);
            for (String topic : tpcs) {
                this.unsubscribeFrom(topic);
            }
            this.topics.clear();
            this.client.disconnect().whenComplete((connAck, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Connecting MQTT client: " + throwable.getMessage(), throwable);
                } else {
                    this.client = null;
                }
            });
        }
    }

    boolean subscribeTo(String topic, ArrivedCallback arrivedCallback) {
        AtomicBoolean done = new AtomicBoolean(false);
        if (!this.configuration.isFilteredTopic(topic) && null != this.client) {
            ((CompletableFuture)((Mqtt5AsyncClient.Mqtt5SubscribeAndCallbackBuilder.Start.Complete)this.client.subscribeWith().topicFilter(topic)).callback(publish -> arrivedCallback.messageArrived(topic, publish.getPayloadAsBytes())).send().whenComplete((subAck, th) -> {
                if (th != null) {
                    LOGGER.error("Subscribing to MQTT topic '" + topic + "': " + th.getMessage(), th);
                } else {
                    LOGGER.info("Subscribed to " + topic);
                    done.set(true);
                    this.topics.add(topic);
                }
            })).join();
        }
        return done.get();
    }

    boolean unsubscribeFrom(String topic) {
        AtomicBoolean done = new AtomicBoolean(false);
        if (!this.configuration.isFilteredTopic(topic) && null != this.client) {
            ((CompletableFuture)((CompletableFuture)((Mqtt5UnsubscribeBuilder.Send.Complete)this.client.unsubscribeWith().topicFilter(topic)).send()).whenComplete((subAck, th) -> {
                if (th != null) {
                    LOGGER.error("Unsubscribing from MQTT topic '" + topic + "': " + th.getMessage(), th);
                } else {
                    LOGGER.info("Unsubscribed from " + topic);
                    done.set(true);
                }
            })).join();
            this.topics.remove(topic);
        }
        return done.get();
    }

    void send(String topic, byte[] payload) {
        if (null != this.client) {
            ((CompletableFuture)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)this.client.publishWith().topic(topic)).payload(payload)).qos(this.qos)).send()).whenComplete((publish, th) -> {
                if (th != null) {
                    LOGGER.error("Acquiring send lock: " + th.getMessage(), th);
                }
            });
        }
    }

    public static interface ArrivedCallback {
        public void messageArrived(String var1, byte[] var2);
    }
}

