/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.core;

import java.util.function.Consumer;
import org.springframework.cloud.function.core.Isolated;
import org.springframework.util.ClassUtils;

public class IsolatedConsumer<T>
implements Consumer<T>,
Isolated {
    private final Consumer<T> consumer;
    private final ClassLoader classLoader;

    public IsolatedConsumer(Consumer<T> consumer) {
        this.consumer = consumer;
        this.classLoader = consumer.getClass().getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void accept(T item) {
        ClassLoader context = ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.classLoader);
        try {
            this.consumer.accept(item);
        }
        finally {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)context);
        }
    }
}

