/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class AppIntercom<T> {
    private String channel;
    private TransportConnector conn;
    private ReceptionCallback<T> commandCallback;

    public AppIntercom(String channel, final Consumer<T> consumer, final Class<T> cls) {
        this.channel = channel;
        this.commandCallback = new ReceptionCallback<T>(){

            @Override
            public void received(T data) {
                consumer.accept(data);
            }

            @Override
            public Class<T> getType() {
                return cls;
            }
        };
    }

    public AppIntercom(Consumer<T> consumer, Class<T> cls) {
        this("intercom", consumer, cls);
    }

    public void start() throws ExecutionException {
        try {
            this.conn = Transport.createConnector();
            if (null != this.conn) {
                this.conn.setReceptionCallback(this.channel, this.commandCallback);
            } else {
                LoggerFactory.getLogger(this.getClass()).error("Cannot set up transport intercom. No connector (null).");
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot set up transport intercom: " + e.getMessage());
        }
    }

    public void stop() {
        if (null != this.conn) {
            try {
                this.conn.detachReceptionCallback(this.channel, this.commandCallback);
                this.conn = null;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot set up transport intercom: " + e.getMessage());
            }
        }
    }

    public void asyncSend(T data) throws IOException {
        if (null != this.conn) {
            this.conn.asyncSend(this.channel, data);
        }
    }

    public void syncSend(T data) throws IOException {
        if (null != this.conn) {
            this.conn.syncSend(this.channel, data);
        }
    }
}

