/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.AbstractReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.impl.AbstractTransportConnector;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.transport.Product;

public class AbstractTransportConnectorTest {
    public static void doTest(ServerAddress addr, Class<? extends Serializer<Product>> serializerType) throws IOException {
        AbstractTransportConnectorTest.doTest(addr, serializerType, null);
    }

    public static void doTest(ServerAddress addr, Class<? extends Serializer<Product>> serializerType, TransportParameterConfigurer configurer) throws IOException {
        Product data1 = new Product("prod1", 10.2);
        Product data2 = new Product("prod2", 5.1);
        System.out.println("Using serializer: " + serializerType.getSimpleName());
        SerializerRegistry.registerSerializer(serializerType);
        TransportParameter.TransportParameterBuilder tpb1 = TransportParameter.TransportParameterBuilder.newBuilder((String)addr.getHost(), (int)addr.getPort()).setApplicationId("cl1");
        if (null != configurer) {
            configurer.configure(tpb1);
        }
        TransportParameter param1 = tpb1.build();
        TransportConnector cl1 = TransportFactory.createConnector();
        cl1.setSerializerProvider(SerializerRegistry.DEFAULT_PROVIDER);
        Assert.assertTrue((cl1.getName().length() > 0 ? 1 : 0) != 0);
        System.out.println("Connecting connector 1 to " + addr.toUri());
        cl1.connect(param1);
        String stream1 = cl1.composeStreamName("", "stream1");
        String stream2 = cl1.composeStreamName("", "stream2");
        Callback cb1 = new Callback();
        cl1.setReceptionCallback(stream2, (ReceptionCallback)cb1);
        TransportParameter.TransportParameterBuilder tpb2 = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setApplicationId("cl2");
        if (null != configurer) {
            configurer.configure(tpb2);
        }
        TransportParameter param2 = tpb2.build();
        TransportConnector cl2 = TransportFactory.createConnector();
        Assert.assertTrue((cl2.getName().length() > 0 ? 1 : 0) != 0);
        System.out.println("Connecting connector 2 to " + addr.toUri());
        cl2.connect(param2);
        Callback cb2 = new Callback();
        cl2.setReceptionCallback(stream1, (ReceptionCallback)cb2);
        System.out.println("Sending/Receiving");
        cl1.syncSend(stream1, (Object)data1);
        cl2.syncSend(stream2, (Object)data2);
        TimeUtils.sleep((int)2000);
        AbstractTransportConnectorTest.assertProduct(data1, cb2);
        AbstractTransportConnectorTest.assertProduct(data2, cb1);
        System.out.println("Cleaning up");
        cl1.disconnect();
        cl2.disconnect();
        SerializerRegistry.unregisterSerializer(Product.class);
    }

    private static void assertProduct(Product expected, Callback received) {
        for (int count = 0; received.data == null && count < 10; ++count) {
            TimeUtils.sleep((int)100);
        }
        Assert.assertNotNull((Object)received.data);
        Assert.assertEquals((Object)expected.getDescription(), (Object)received.data.getDescription());
        Assert.assertEquals((double)expected.getPrice(), (double)received.data.getPrice(), (double)0.01);
        received.data = null;
    }

    @Test
    public void testApplyAuthenticationKey() {
        boolean known = ResourceLoader.knowsResourceResolver((ResourceResolver)ResourceLoader.MAVEN_RESOLVER);
        if (!known) {
            ResourceLoader.registerResourceResolver((ResourceResolver)ResourceLoader.MAVEN_RESOLVER, (boolean)true);
        }
        Assert.assertTrue((boolean)AbstractTransportConnector.applyAuthenticationKey((String)"amqp", (u, p, e) -> {
            Assert.assertNotNull((Object)u);
            Assert.assertTrue((u.length() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)p);
            Assert.assertTrue((p.length() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)e);
            Assert.assertTrue((e.length() > 0 ? 1 : 0) != 0);
            return true;
        }));
        Assert.assertFalse((boolean)AbstractTransportConnector.applyAuthenticationKey((String)"xyz", (u, p, e) -> {
            Assert.assertNull((Object)u);
            Assert.assertNull((Object)p);
            Assert.assertNull((Object)e);
            return false;
        }));
        Assert.assertTrue((boolean)AbstractTransportConnector.applyAuthenticationKey((String)"ano", (u, p, e) -> {
            Assert.fail((String)"shall not be called");
            return false;
        }, () -> true));
        Assert.assertFalse((boolean)AbstractTransportConnector.applyAuthenticationKey((String)"ano", (u, p, e) -> {
            Assert.fail((String)"shall not be called");
            return false;
        }, () -> false));
        if (!known) {
            ResourceLoader.unregisterResourceResolver((ResourceResolver)ResourceLoader.MAVEN_RESOLVER);
        }
    }

    public static interface TransportParameterConfigurer {
        public void configure(TransportParameter.TransportParameterBuilder var1);
    }

    static class Callback
    extends AbstractReceptionCallback<Product> {
        private Product data;

        protected Callback() {
            super(Product.class);
        }

        public void received(Product data) {
            this.data = data;
        }
    }
}

