/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.transport.serialization.GenericJsonSerializer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class GenericJsonSerializerTest {
    @Test
    public void testDataClassSerializer() throws IOException {
        GenericJsonSerializer ser = new GenericJsonSerializer(DataClass.class);
        DataClass d = new DataClass();
        d.setValue(52);
        DataClass r = (DataClass)ser.from(ser.to((Object)d));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)d.getValue(), (long)r.getValue());
        Assert.assertEquals(DataClass.class, (Object)ser.getType());
        r = (DataClass)ser.clone((Object)r);
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)0L, (long)r.getValue());
    }

    @Test
    public void testDataClassWithCopyConstructorSerializer() throws IOException {
        GenericJsonSerializer ser = new GenericJsonSerializer(DataClassWithCopyConstructor.class);
        DataClassWithCopyConstructor d = new DataClassWithCopyConstructor();
        d.setValue(42);
        DataClassWithCopyConstructor r = (DataClassWithCopyConstructor)ser.from(ser.to((Object)d));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)d.getValue(), (long)r.getValue());
        Assert.assertEquals(DataClassWithCopyConstructor.class, (Object)ser.getType());
        r = (DataClassWithCopyConstructor)ser.clone((Object)r);
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)d.getValue(), (long)r.getValue());
    }

    public static class DataClass {
        private int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class DataClassWithCopyConstructor
    extends DataClass {
        public DataClassWithCopyConstructor() {
        }

        public DataClassWithCopyConstructor(DataClassWithCopyConstructor data) {
            this.setValue(data.getValue());
        }
    }
}

