/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.transport.serialization.ByteArraySerializer;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.serialization.StringSerializer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SerializerRegistryTest {
    @Test
    public void testName() throws IOException {
        String name = "XXX";
        String old = SerializerRegistry.setName((String)"XXX");
        Assert.assertEquals((Object)"XXX", (Object)SerializerRegistry.getName());
        SerializerRegistry.setName((String)old);
        SerializerRegistry.resetDefaults();
        Serializer ser = SerializerRegistry.getSerializer(String.class);
        Assert.assertNotNull((Object)ser);
        String test = "ABBA";
        byte[] data = (byte[])ser.to((Object)test);
        String tmp = (String)ser.from((Object)data);
        Assert.assertEquals((Object)test, (Object)tmp);
    }

    @Test
    public void defaultStringSerializerTest() throws IOException {
        StringSerializer s1 = new StringSerializer();
        String test = "a1b2c3!";
        Assert.assertEquals((Object)"a1b2c3!", (Object)s1.from(s1.to("a1b2c3!")));
        Assert.assertEquals(String.class, (Object)s1.getType());
        Assert.assertEquals((Object)"a1b2c3!", (Object)s1.clone("a1b2c3!"));
    }

    @Test
    public void defaultByteArraySerializerTest() throws IOException {
        ByteArraySerializer s1 = new ByteArraySerializer();
        byte[] test = "a1b2c3!".getBytes();
        Assert.assertArrayEquals((byte[])test, (byte[])s1.from(s1.to(test)));
        Assert.assertEquals(byte[].class, (Object)s1.getType());
        Assert.assertArrayEquals((byte[])test, (byte[])s1.clone(test));
    }
}

