/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.DefaultPluginDescriptor;
import de.iip_ecosphere.platform.support.plugins.FolderClasspathPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import test.de.iip_ecosphere.platform.transport.AbstractTestServer;
import test.de.iip_ecosphere.platform.transport.TestServerBuilder;

public class TestServerPluginDescriptor
extends DefaultPluginDescriptor<TestServerBuilder> {
    public TestServerPluginDescriptor(String id, TestServerBuilder.InstanceCreator instanceCreator) {
        super(id, null, TestServerBuilder.class, p -> new TestServerBuilder(id, instanceCreator, p.getInstallDir()));
    }

    public static class JvmTestServer
    extends AbstractTestServer {
        private String id;
        private String cls;
        private Process proc;
        private ServerAddress address;
        private File installDir;
        private ProcessUpSupplier checker;
        private int upTimeout = 10000;

        public JvmTestServer(String id, String cls, ServerAddress address, File installDir, ProcessUpSupplier checker) {
            this.id = id;
            this.cls = cls;
            this.address = address;
            this.installDir = installDir;
            this.checker = checker;
        }

        public JvmTestServer setUpTimeout(int upTimeout) {
            this.upTimeout = upTimeout;
            if (this.upTimeout > 0 && this.upTimeout < 200) {
                this.upTimeout = 250;
            }
            return this;
        }

        public Server start() {
            AtomicBoolean started = new AtomicBoolean(false);
            try {
                File java = new File(System.getProperty("java.home") + "/bin/java");
                File instDir = this.installDir == null ? new File("") : this.installDir;
                instDir = instDir.getCanonicalFile();
                File cp = FolderClasspathPluginSetupDescriptor.findClasspathFile((File)instDir, (String)(OsUtils.isWindows() ? "-win" : "-linux"));
                ArrayList<String> args = new ArrayList<String>();
                args.add(java.getAbsolutePath());
                args.add("-cp");
                args.add("@" + cp.getAbsolutePath());
                args.add(this.cls);
                args.add(String.valueOf(this.address.getPort()));
                args.add(new File("").getAbsolutePath());
                ProcessBuilder b = new ProcessBuilder(args);
                instDir = FolderClasspathPluginSetupDescriptor.adjustBase((File)instDir);
                b.directory(instDir.getAbsoluteFile());
                LoggerFactory.getLogger(this.getClass()).info("Spawning process for plugin {} with arguments {} in directory {}", new Object[]{this.id, String.join((CharSequence)" ", args), instDir});
                this.proc = b.start();
                StreamGobbler.attach((Process)this.proc, s -> started.set(this.checker.isRunning((String)s)), null);
                if (this.upTimeout > 0) {
                    TimeUtils.waitFor(() -> !started.get() && !this.checker.isRunning(), (int)this.upTimeout, (int)200);
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot start {}: {}", (Object)this.cls, (Object)e.getMessage());
            }
            return this;
        }

        public void stop(boolean dispose) {
            if (null != this.proc) {
                this.proc.destroyForcibly();
            }
        }
    }

    public static interface ProcessUpSupplier {
        public boolean isRunning(String var1);

        default public boolean isRunning() {
            return false;
        }
    }
}

