/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.connectors;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import java.io.Serializable;

public class TransportSetup
implements Serializable {
    private static final long serialVersionUID = 8110026253178816807L;
    private String host;
    private int port;
    private String keystoreKey;
    private String keyAlias;
    private boolean hostnameVerification = false;
    private String authenticationKey;
    private int gatewayPort = 10000;
    private String netmask = "";

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getKeystoreKey() {
        return this.keystoreKey;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public boolean getHostnameVerification() {
        return this.hostnameVerification;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKeystoreKey(String keystoreKey) {
        this.keystoreKey = keystoreKey;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public void setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
    }

    public int getGatewayPort() {
        return this.gatewayPort;
    }

    public void setGatewayPort(int gatewayPort) {
        this.gatewayPort = gatewayPort;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    public Endpoint getGatewayServerEndpoint(Schema schema, String path) {
        return new Endpoint(schema, this.getHost(), this.getGatewayPort(), path);
    }

    public boolean isLocalGatewayEndpoint() {
        return this.getGatewayPort() < 0;
    }

    public TransportParameter createParameter() {
        return TransportParameter.TransportParameterBuilder.newBuilder(this.host, this.port).setKeystoreKey(this.keystoreKey).setKeyAlias(this.keyAlias).setHostnameVerification(this.hostnameVerification).setAuthenticationKey(this.authenticationKey).build();
    }

    public TransportSetup copy() {
        TransportSetup setup = new TransportSetup();
        setup.setAuthenticationKey(this.authenticationKey);
        setup.setHost(this.host);
        setup.setPort(this.port);
        setup.setHostnameVerification(this.hostnameVerification);
        setup.setKeyAlias(this.keyAlias);
        setup.setKeystoreKey(this.keystoreKey);
        setup.setGatewayPort(this.gatewayPort);
        return setup;
    }
}

