/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.status;

import de.iip_ecosphere.platform.support.TaskRegistry;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.io.IOException;

public class TaskUtils {
    private static Task lastTask;

    public static String executeAsTask(String componentId, JsonResultWrapper.ExceptionFunction func, Object ... params) {
        return TaskUtils.executeAsTask(TaskRegistry.registerTask(), componentId, func, params);
    }

    public static String executeAsTask(String componentId, JsonResultWrapper.ExceptionFunction func, TaskCompletedPredicate pred, Object ... params) {
        return TaskUtils.executeAsTask(null, componentId, func, pred, params);
    }

    public static String executeAsTask(TaskRegistry.TaskData data, String componentId, JsonResultWrapper.ExceptionFunction func, Object ... params) {
        return TaskUtils.executeAsTask(data, componentId, func, null, params);
    }

    public static String executeAsTask(TaskRegistry.TaskData data, String componentId, JsonResultWrapper.ExceptionFunction func, TaskCompletedPredicate pred, Object ... params) {
        Task task = new Task(componentId, func, pred, params);
        Thread thread = new Thread(task);
        if (null == data || TaskRegistry.NO_TASK == data) {
            data = TaskRegistry.registerTask((Thread)thread);
            data.setRequiredStopCalls(2);
        }
        task.data = data;
        thread.start();
        return data.getId();
    }

    public static TaskRegistry.TaskData getLastTaskData() {
        return lastTask != null ? TaskUtils.lastTask.data : null;
    }

    @FunctionalInterface
    public static interface TaskCompletedPredicate {
        public boolean test(TaskRegistry.TaskData var1, StatusMessage var2);
    }

    private static class Task
    implements Runnable {
        private TaskRegistry.TaskData data;
        private String componentId;
        private JsonResultWrapper.ExceptionFunction func;
        private TaskCompletedPredicate pred;
        private Object[] params;

        private Task(String componentId, JsonResultWrapper.ExceptionFunction func, TaskCompletedPredicate pred, Object[] params) {
            this.componentId = componentId;
            this.func = func;
            this.pred = pred;
            this.params = params;
            lastTask = this;
        }

        @Override
        public void run() {
            if (null != this.pred) {
                ReceptionCallback<StatusMessage> cb = new ReceptionCallback<StatusMessage>(){

                    @Override
                    public void received(StatusMessage msg) {
                        if (data.sameTask(msg.getTaskId()) && pred.test(data, msg)) {
                            try {
                                TransportConnector tc = Transport.getConnector();
                                if (null != tc) {
                                    tc.detachReceptionCallback("ComponentStatus", this);
                                } else {
                                    LoggerFactory.getLogger(TaskUtils.class).error("Cannot stop tracking task status of {} for component {}: No transport connector", (Object)data.getId(), (Object)componentId);
                                }
                            }
                            catch (IOException e) {
                                LoggerFactory.getLogger(TaskUtils.class).error("Cannot stop tracking task status of {} for component {}: {}", new Object[]{data.getId(), componentId, e.getMessage()});
                            }
                        }
                    }

                    @Override
                    public Class<StatusMessage> getType() {
                        return StatusMessage.class;
                    }
                };
                try {
                    TransportConnector tc = Transport.createConnector();
                    if (null != tc) {
                        tc.setReceptionCallback("ComponentStatus", cb);
                    } else {
                        LoggerFactory.getLogger(TaskUtils.class).error("Cannot track task status of {} for component {}: Cannot connect to transport", (Object)this.data.getId(), (Object)this.componentId);
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(TaskUtils.class).error("Cannot track task status of {} for component {}: {}", new Object[]{this.data.getId(), this.componentId, e.getMessage()});
                }
            }
            try {
                Transport.sendStatus(this.createStatusMessage(this.componentId, ActionTypes.RESULT, this.func.apply(this.params)));
            }
            catch (Throwable e) {
                Transport.sendStatus(this.createStatusMessage(this.componentId, ActionTypes.ERROR, e.getMessage()));
            }
            TaskRegistry.stopTask((String)this.data.getId());
        }

        private StatusMessage createStatusMessage(String componentId, ActionTypes type, Object result) {
            return new StatusMessage(type, componentId, Id.getDeviceId()).withTask(this.data).withResult(result);
        }
    }
}

