/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.boot;

import de.uni_hildesheim.sse.monitoring.runtime.boot.ArrayList;
import de.uni_hildesheim.sse.monitoring.runtime.boot.BooleanValue;
import de.uni_hildesheim.sse.monitoring.runtime.boot.DebugState;
import de.uni_hildesheim.sse.monitoring.runtime.boot.GroupAccountingType;
import de.uni_hildesheim.sse.monitoring.runtime.boot.InstanceIdentifierKind;
import de.uni_hildesheim.sse.monitoring.runtime.boot.ResourceType;

public class MonitoringGroupSettings {
    private static final ArrayList<MonitoringGroupSettings> POOL = new ArrayList(5);
    private String[] id;
    private DebugState[] debugStates;
    private GroupAccountingType gType;
    private ResourceType[] resources;
    private InstanceIdentifierKind instanceIdentifierKind;
    private BooleanValue distributeValues;
    private BooleanValue considerContained;

    private MonitoringGroupSettings() {
        this.clear();
    }

    public MonitoringGroupSettings create() {
        return new MonitoringGroupSettings();
    }

    public void clear() {
        this.id = null;
        this.debugStates = DebugState.DEFAULT;
        this.gType = GroupAccountingType.DEFAULT;
        this.resources = ResourceType.SET_DEFAULT;
        this.distributeValues = BooleanValue.DEFAULT;
        this.considerContained = BooleanValue.DEFAULT;
        this.instanceIdentifierKind = InstanceIdentifierKind.NONE;
    }

    public void setBasics(String[] stringArray, DebugState[] debugStateArray, GroupAccountingType groupAccountingType, ResourceType[] resourceTypeArray, InstanceIdentifierKind instanceIdentifierKind) {
        this.id = stringArray;
        this.debugStates = debugStateArray;
        this.gType = groupAccountingType;
        this.resources = resourceTypeArray;
        this.instanceIdentifierKind = instanceIdentifierKind;
    }

    public void setMulti(BooleanValue booleanValue, BooleanValue booleanValue2) {
        this.distributeValues = booleanValue;
        this.considerContained = booleanValue2;
    }

    public String[] getId() {
        return this.id;
    }

    public DebugState[] getDebugStates() {
        return this.debugStates;
    }

    public GroupAccountingType getAccountingType() {
        return this.gType;
    }

    public ResourceType[] getResources() {
        return this.resources;
    }

    public InstanceIdentifierKind getInstanceIdentifierKind() {
        return this.instanceIdentifierKind;
    }

    public BooleanValue getDistributeValues() {
        return this.distributeValues;
    }

    public BooleanValue getConsiderContained() {
        return this.considerContained;
    }

    public static final MonitoringGroupSettings getFromPool() {
        int n = POOL.size();
        MonitoringGroupSettings monitoringGroupSettings = 0 == n ? new MonitoringGroupSettings() : POOL.remove(n - 1);
        return monitoringGroupSettings;
    }

    public static final void release(MonitoringGroupSettings monitoringGroupSettings) {
        monitoringGroupSettings.clear();
        POOL.add(monitoringGroupSettings);
    }
}

