/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.boot;

import de.uni_hildesheim.sse.monitoring.runtime.boot.ArrayList;
import de.uni_hildesheim.sse.monitoring.runtime.boot.Poolable;

public class ObjectPool<T extends Poolable<T>> {
    private ArrayList<T> pool;
    private T prototype;
    private int maxSize = 0;

    public ObjectPool(T t) {
        this.prototype = t;
        this.pool = new ArrayList(10);
    }

    public ObjectPool(T t, int n) {
        this.prototype = t;
        this.maxSize = n;
        int n2 = n;
        if (n2 < 10) {
            n2 = 10;
        }
        this.pool = new ArrayList(n2);
    }

    public final synchronized T getFromPool() {
        int n = this.pool.size();
        Poolable poolable = 0 == n ? (Poolable)this.prototype.create() : (Poolable)this.pool.remove(n - 1);
        return (T)poolable;
    }

    public final synchronized void release(T t) {
        t.clear();
        if (this.maxSize == 0 || this.maxSize > 0 && this.pool.size() < this.maxSize) {
            this.pool.add(t);
        }
    }

    public synchronized int size() {
        return this.pool.size();
    }
}

