/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.boot;

public enum ResourceType {
    NONE,
    ALL,
    CPU_TIME,
    MEMORY,
    FILE_IO,
    NET_IO;

    public static final ResourceType[] SET_ALL;
    public static final ResourceType[] SET_DEFAULT;
    public static final ResourceType[] SET_NONE;
    public static final ResourceType[] SET_ANYWAY;

    public static final boolean isAll(ResourceType[] resourceTypeArray) {
        return resourceTypeArray == SET_ALL || resourceTypeArray.length == 1 && resourceTypeArray[0] == ALL;
    }

    public static final boolean isNone(ResourceType[] resourceTypeArray) {
        return resourceTypeArray == SET_NONE || resourceTypeArray.length == 1 && resourceTypeArray[0] == NONE;
    }

    public static final boolean isType(ResourceType[] resourceTypeArray, ResourceType resourceType) {
        return resourceTypeArray.length == 1 && resourceTypeArray[0] == resourceType;
    }

    public static final boolean contains(ResourceType[] resourceTypeArray, ResourceType resourceType) {
        boolean bl;
        if (1 == resourceTypeArray.length) {
            bl = NONE == resourceTypeArray[0] ? false : (ALL == resourceTypeArray[0] ? true : resourceType == resourceTypeArray[0]);
        } else {
            bl = false;
            for (int i = 0; !bl && i < resourceTypeArray.length; ++i) {
                bl = resourceTypeArray[i] == resourceType;
            }
        }
        return bl;
    }

    public static final ResourceType[] ensureSubset(ResourceType[] resourceTypeArray, ResourceType[] resourceTypeArray2) {
        boolean bl = false;
        if (0 == resourceTypeArray2.length) {
            bl = false;
        } else if (1 == resourceTypeArray2.length && resourceTypeArray2[0] == ALL) {
            bl = false;
        } else if (1 == resourceTypeArray2.length && resourceTypeArray2[0] == NONE) {
            bl = false;
        } else {
            ResourceType[] resourceTypeArray3 = new ResourceType[resourceTypeArray.length];
            int n = 0;
            block0: for (int i = 0; i < resourceTypeArray.length; ++i) {
                for (int j = 0; j < resourceTypeArray2.length; ++j) {
                    if (resourceTypeArray[i] != resourceTypeArray2[j]) continue;
                    resourceTypeArray3[n++] = resourceTypeArray[i];
                    continue block0;
                }
            }
            if (0 == n) {
                resourceTypeArray2 = new ResourceType[]{NONE};
            } else {
                resourceTypeArray2 = new ResourceType[n];
                System.arraycopy(resourceTypeArray3, 0, resourceTypeArray2, 0, n);
            }
        }
        if (bl) {
            resourceTypeArray2 = new ResourceType[resourceTypeArray.length];
            System.arraycopy(resourceTypeArray, 0, resourceTypeArray2, 0, resourceTypeArray.length);
        }
        return resourceTypeArray2;
    }

    static {
        SET_ALL = new ResourceType[]{ALL};
        SET_DEFAULT = new ResourceType[0];
        SET_NONE = new ResourceType[]{NONE};
        SET_ANYWAY = new ResourceType[]{FILE_IO, NET_IO};
    }
}

