/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.boot;

import de.uni_hildesheim.sse.monitoring.runtime.boot.DebugState;
import de.uni_hildesheim.sse.monitoring.runtime.boot.ResourceType;

public enum StreamType {
    NONE(null, new DebugState[0]),
    NET(ResourceType.NET_IO, DebugState.NET_IN, DebugState.NET_OUT),
    FILE(ResourceType.FILE_IO, DebugState.FILE_IN, DebugState.FILE_OUT);

    private ResourceType resource;
    private DebugState[] states;

    private StreamType(ResourceType resourceType, DebugState ... debugStateArray) {
        this.states = debugStateArray;
    }

    public boolean matches(DebugState debugState) {
        boolean bl = false;
        if (null != this.states) {
            for (int i = 0; !bl && i < this.states.length; ++i) {
                bl = this.states[i] == debugState;
            }
        }
        return bl;
    }

    public ResourceType getResource() {
        return this.resource;
    }

    public static final StreamType getForURL(String string) {
        StreamType streamType = NONE;
        if ("file".equalsIgnoreCase(string)) {
            streamType = FILE;
        }
        return streamType;
    }

    public String toCode() {
        return StreamType.class.getName() + "." + this.name();
    }
}

