/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.wrap;

import de.uni_hildesheim.sse.monitoring.runtime.boot.RecorderFrontend;
import de.uni_hildesheim.sse.monitoring.runtime.boot.StreamType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DelegatingInputStream
extends InputStream {
    private InputStream stream;
    private boolean inRead3 = false;
    private boolean inRead1 = false;
    private StreamType type;
    private String recId;

    public DelegatingInputStream(InputStream inputStream, StreamType streamType) {
        this(inputStream, streamType, null);
    }

    public DelegatingInputStream(InputStream inputStream, StreamType streamType, String string) {
        this.stream = inputStream;
        this.type = streamType;
        this.recId = string;
    }

    public static final InputStream createFrom(InputStream inputStream, URL uRL, String string) {
        StreamType streamType = StreamType.getForURL(uRL.getProtocol());
        if (null != streamType) {
            return new DelegatingInputStream(inputStream, streamType, string);
        }
        return inputStream;
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public synchronized void mark(int n) {
        this.stream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.stream.skip(l);
    }

    @Override
    public int read() throws IOException {
        int n = this.stream.read();
        if (!this.inRead3 && !this.inRead1 && null != RecorderFrontend.instance) {
            RecorderFrontend.instance.readIo(this.recId, null, 1, this.type);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.inRead1 = true;
        int n = 0;
        try {
            n = this.stream.read(byArray);
            if (!this.inRead3 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.readIo(this.recId, null, n, this.type);
            }
            this.inRead1 = false;
        }
        catch (IOException iOException) {
            this.inRead1 = false;
            throw iOException;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.inRead3 = true;
        int n3 = 0;
        try {
            n3 = this.stream.read(byArray, n, n2);
            if (!this.inRead1 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.readIo(this.recId, null, n3, this.type);
            }
            this.inRead3 = false;
        }
        catch (IOException iOException) {
            this.inRead3 = false;
            throw iOException;
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

