/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.wrap;

import de.uni_hildesheim.sse.monitoring.runtime.boot.RecorderFrontend;
import de.uni_hildesheim.sse.monitoring.runtime.boot.StreamType;
import java.io.IOException;
import java.io.OutputStream;

public class DelegatingOutputStream
extends OutputStream {
    private OutputStream stream;
    private boolean inWrite3 = false;
    private boolean inWrite1 = false;
    private StreamType type;
    private String recId;

    public DelegatingOutputStream(OutputStream outputStream, StreamType streamType) {
        this(outputStream, streamType, null);
    }

    public DelegatingOutputStream(OutputStream outputStream, StreamType streamType, String string) {
        this.stream = outputStream;
        this.type = streamType;
        this.recId = string;
    }

    @Override
    public void write(int n) throws IOException {
        this.stream.write(n);
        if (!this.inWrite1 && !this.inWrite3 && null != RecorderFrontend.instance) {
            RecorderFrontend.instance.writeIo(this.recId, null, 1, this.type);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.inWrite1 = true;
        try {
            this.stream.write(byArray);
            if (!this.inWrite3 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.writeIo(this.recId, null, byArray.length, this.type);
            }
            this.inWrite1 = false;
        }
        catch (IOException iOException) {
            this.inWrite1 = false;
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.inWrite3 = true;
        try {
            this.stream.write(byArray, n, n2);
            if (!this.inWrite1 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.writeIo(this.recId, null, n2, this.type);
            }
            this.inWrite3 = false;
        }
        catch (IOException iOException) {
            this.inWrite3 = false;
            throw iOException;
        }
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

