/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.wrap;

import de.uni_hildesheim.sse.monitoring.runtime.boot.RecorderFrontend;
import de.uni_hildesheim.sse.monitoring.runtime.boot.StreamType;
import java.io.IOException;
import java.io.Writer;

public class DelegatingWriter
extends Writer {
    private Writer writer;
    private boolean inWrite3 = false;
    private boolean inWrite1 = false;
    private StreamType type;
    private String recId;

    public DelegatingWriter(Writer writer, StreamType streamType) {
        this(writer, streamType, null);
    }

    public DelegatingWriter(Writer writer, StreamType streamType, String string) {
        this.writer = writer;
        this.type = streamType;
        this.recId = string;
    }

    @Override
    public void write(int n) throws IOException {
        this.writer.write(n);
        if (!this.inWrite1 && !this.inWrite3 && null != RecorderFrontend.instance) {
            RecorderFrontend.instance.writeIo(this.recId, null, 1, this.type);
        }
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.inWrite1 = true;
        try {
            this.writer.write(cArray);
            if (!this.inWrite3 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.writeIo(this.recId, null, cArray.length, this.type);
            }
            this.inWrite1 = false;
        }
        catch (IOException iOException) {
            this.inWrite1 = false;
            throw iOException;
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.inWrite3 = true;
        try {
            this.writer.write(cArray, n, n2);
            if (!this.inWrite1 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.writeIo(this.recId, null, n2, this.type);
            }
            this.inWrite3 = false;
        }
        catch (IOException iOException) {
            this.inWrite3 = false;
            throw iOException;
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public Writer append(char c) throws IOException {
        this.writer.append(c);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.writer.append(charSequence);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
        this.writer.append(charSequence, n, n2);
        return this;
    }
}

