/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.wrap;

import de.uni_hildesheim.sse.monitoring.runtime.boot.RecorderFrontend;
import de.uni_hildesheim.sse.monitoring.runtime.boot.StreamType;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class InstrumentedFileOutputStream
extends FileOutputStream {
    private boolean inWrite3 = false;
    private boolean inWrite1 = false;
    private String recId;

    public InstrumentedFileOutputStream(String string) throws FileNotFoundException {
        super(string);
    }

    public InstrumentedFileOutputStream(String string, boolean bl) throws FileNotFoundException {
        super(string, bl);
    }

    public InstrumentedFileOutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public InstrumentedFileOutputStream(File file, boolean bl) throws FileNotFoundException {
        super(file, bl);
    }

    public InstrumentedFileOutputStream(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public InstrumentedFileOutputStream(String string, String string2) throws FileNotFoundException {
        super(string);
        this.recId = string2;
    }

    public InstrumentedFileOutputStream(String string, boolean bl, String string2) throws FileNotFoundException {
        super(string, bl);
        this.recId = string2;
    }

    public InstrumentedFileOutputStream(File file, String string) throws FileNotFoundException {
        super(file);
        this.recId = string;
    }

    public InstrumentedFileOutputStream(File file, boolean bl, String string) throws FileNotFoundException {
        super(file, bl);
        this.recId = string;
    }

    public InstrumentedFileOutputStream(FileDescriptor fileDescriptor, String string) {
        super(fileDescriptor);
        this.recId = string;
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        if (!this.inWrite1 && !this.inWrite3 && null != RecorderFrontend.instance) {
            RecorderFrontend.instance.writeIo(this.recId, null, 1, StreamType.FILE);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.inWrite1 = true;
        try {
            super.write(byArray);
            if (!this.inWrite3 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.writeIo(this.recId, null, byArray.length, StreamType.FILE);
            }
            this.inWrite1 = false;
        }
        catch (IOException iOException) {
            this.inWrite1 = false;
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.inWrite3 = true;
        try {
            super.write(byArray, n, n2);
            if (!this.inWrite1 && null != RecorderFrontend.instance) {
                RecorderFrontend.instance.writeIo(this.recId, null, n2, StreamType.FILE);
            }
            this.inWrite3 = false;
        }
        catch (IOException iOException) {
            this.inWrite3 = false;
            throw iOException;
        }
    }
}

