/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.monitoring.runtime.wrap;

import de.uni_hildesheim.sse.monitoring.runtime.boot.RecorderFrontend;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ShutdownMonitor
extends Thread {
    private static Boolean executeEndCode = null;
    private String invoke;
    private ClassLoader loader;
    private boolean printStatistics;

    public ShutdownMonitor(ClassLoader classLoader, String string) {
        this(classLoader, string, true);
    }

    public ShutdownMonitor(ClassLoader classLoader, String string, boolean bl) {
        this.invoke = string;
        this.loader = classLoader;
        this.printStatistics = bl;
    }

    public static void setWaitEndSystemNotification(boolean bl) {
        if (bl) {
            executeEndCode = Boolean.TRUE;
        }
    }

    public static void endSystemNotification() {
        executeEndCode = Boolean.TRUE;
    }

    public static void endMonitoring(boolean bl, ClassLoader classLoader, String string) {
        int n;
        try {
            RecorderFrontend recorderFrontend = RecorderFrontend.instance;
            if (null != recorderFrontend) {
                recorderFrontend.notifyProgramEnd();
                if (bl) {
                    recorderFrontend.printStatistics();
                }
                recorderFrontend.endSystem();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(System.out);
        }
        while (Boolean.FALSE == executeEndCode) {
            Thread.yield();
        }
        if (null != string && string.length() > 0 && (n = string.lastIndexOf(46)) > 0 && n < string.length()) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string3.endsWith(")") && (string3 = string3.substring(0, string3.length() - 1)).endsWith("(")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            try {
                Class<?> clazz = classLoader.loadClass(string2);
                Method method = clazz.getMethod(string3, new Class[0]);
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                ShutdownMonitor.handleException(string, invocationTargetException);
                invocationTargetException.getCause().printStackTrace();
            }
            catch (Exception exception) {
                ShutdownMonitor.handleException(string, exception);
            }
        }
    }

    private static void handleException(String string, Exception exception) {
        System.err.println("SPASS-meter: cannot call " + string + ": " + exception.getClass().getName() + " " + exception.getMessage());
    }

    @Override
    public void run() {
        ShutdownMonitor.endMonitoring(this.printStatistics, this.loader, this.invoke);
    }
}

