/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.debug;

import eu.qualimaster.coordination.CoordinationConfiguration;
import eu.qualimaster.coordination.RepositoryHelper;
import eu.qualimaster.easy.extension.debug.AbstractDebug;
import eu.qualimaster.easy.extension.internal.AlgorithmProfileHelper;
import eu.qualimaster.easy.extension.internal.QmProjectDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.ssehub.easy.basics.modelManagement.ModelInitializer;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;
import org.apache.commons.io.FileUtils;

public class DebugProfile
extends AbstractDebug {
    public static void main(String[] args) throws ModelManagementException, IOException {
        if (args.length == 0) {
            System.out.println("qualimaster.profile: <model location>");
            System.exit(0);
        } else {
            Properties prop = new Properties();
            prop.put("repository.pipelineElements.url", "https://projects.sse.uni-hildesheim.de/qm/maven/");
            CoordinationConfiguration.configure((Properties)prop, (boolean)false);
            File tmp = new File(FileUtils.getTempDirectory(), "qmDebugProfile");
            FileUtils.deleteDirectory((File)tmp);
            tmp.mkdirs();
            File modelLocation = new File(args[0]);
            if (!modelLocation.exists()) {
                System.out.println("model location " + String.valueOf(modelLocation) + " does not exist");
                System.exit(0);
            }
            DebugProfile.initialize();
            ModelInitializer.registerLoader((ProgressObserver)ProgressObserver.NO_OBSERVER);
            ModelInitializer.addLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
            Project project = (Project)RepositoryHelper.obtainModel((ModelManagement)VarModel.INSTANCE, (String)"QM", null);
            Configuration monConfig = RepositoryHelper.createConfiguration((Project)project, (String)"MONITORING", null);
            QmProjectDescriptor source = new QmProjectDescriptor(tmp);
            try {
                AlgorithmProfileHelper.ProfileData data = AlgorithmProfileHelper.createProfilePipeline(monConfig, "ProfileTestPip", "fCorrelationFinancial", "TopoSoftwareCorrelationFinancial", (IProjectDescriptor)source);
                System.out.println("Creation successful. " + String.valueOf(data.getPipeline()));
            }
            catch (VilException e) {
                e.printStackTrace();
            }
            ModelInitializer.removeLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        }
    }
}

