/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.observables.IObservable;
import java.util.HashMap;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.ParameterMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

@Instantiator(value="weightAll")
public class Weighting
implements IVilType {
    @ReturnGenerics(value={String.class, Double.class})
    public static Map<String, Double> weightAll(@ParameterMeta(generics={String.class, Map.class, IObservable.class, Double.class}) Map<String, Map<IObservable, Double>> predictions, @ParameterMeta(generics={IObservable.class, Double.class}) Map<IObservable, Double> weighting) {
        return Weighting.weightAll(predictions, weighting, null);
    }

    @ReturnGenerics(value={String.class, Double.class})
    public static Map<String, Double> weightAll(@ParameterMeta(generics={String.class, Map.class, IObservable.class, Double.class}) Map<String, Map<IObservable, Double>> predictions, @ParameterMeta(generics={IObservable.class, Double.class}) Map<IObservable, Double> weighting, @ParameterMeta(generics={IObservable.class}) Set<IObservable> costs) {
        TypeDescriptor[] types = TypeDescriptor.createArray((int)2);
        types[0] = TypeRegistry.stringType();
        types[1] = TypeRegistry.realType();
        return new Map(new HashMap<String, Double>(Weighting.weightAllImpl(predictions, weighting, costs)), types);
    }

    @Invisible
    public static java.util.Map<String, Double> weightAllImpl(@ParameterMeta(generics={String.class, Map.class, IObservable.class, Double.class}) Map<String, Map<IObservable, Double>> predictions, @ParameterMeta(generics={IObservable.class, Double.class}) Map<IObservable, Double> weighting, @ParameterMeta(generics={IObservable.class}) Set<IObservable> costs) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (predictions != null && weighting != null) {
            MaxProcessor maxProcessor = new MaxProcessor();
            Weighting.processPredictions(predictions, weighting, maxProcessor);
            UpdateProcessor updateProcessor = new UpdateProcessor(maxProcessor, weighting, result, costs);
            Weighting.processPredictions(predictions, weighting, updateProcessor);
        }
        return result;
    }

    private static void processPredictions(Map<String, Map<IObservable, Double>> predictions, Map<IObservable, Double> weighting, IPredictionProcessor processor) {
        for (String name : predictions.keys()) {
            Object map = predictions.get((Object)name);
            if (map instanceof Map) {
                algPredictions = (Map)map;
                for (IObservable obs : weighting.keys()) {
                    if (obs == null) continue;
                    processor.process(obs, (Double)algPredictions.get((Object)obs));
                }
            } else if (map instanceof java.util.Map) {
                algPredictions = (java.util.Map)map;
                for (IObservable obs : weighting.keys()) {
                    if (obs == null) continue;
                    processor.process(obs, (Double)algPredictions.get(obs));
                }
            }
            processor.postProcess(name);
        }
    }

    private static interface IPredictionProcessor {
        public void process(IObservable var1, Double var2);

        public void postProcess(String var1);
    }

    private static class MaxProcessor
    implements IPredictionProcessor {
        private HashMap<IObservable, Double> max = new HashMap();

        private MaxProcessor() {
        }

        public HashMap<IObservable, Double> getResult() {
            return this.max;
        }

        @Override
        public void process(IObservable obs, Double prediction) {
            Double v = this.max.get(obs);
            if (prediction != null) {
                if (v == null) {
                    this.max.put(obs, prediction);
                } else {
                    this.max.put(obs, Math.max(prediction, v));
                }
            }
        }

        @Override
        public void postProcess(String name) {
        }
    }

    private static class UpdateProcessor
    implements IPredictionProcessor {
        private HashMap<IObservable, Double> max;
        private Map<IObservable, Double> weighting;
        private HashMap<String, Double> result;
        private Set<IObservable> costs;
        private double sum = 0.0;
        private double weights = 0.0;

        private UpdateProcessor(MaxProcessor max, Map<IObservable, Double> weighting, HashMap<String, Double> result, Set<IObservable> costs) {
            this.max = max.getResult();
            this.weighting = weighting;
            this.result = result;
            this.costs = costs;
        }

        @Override
        public void process(IObservable obs, Double prediction) {
            Double weight = (Double)this.weighting.get((Object)obs);
            if (weight != null) {
                if (prediction != null) {
                    double p = prediction;
                    if (weight < 0.0) {
                        Double m = this.max.get(obs);
                        if (m != null) {
                            p = m - p;
                        }
                        weight = weight * -1.0;
                    }
                    this.sum += p * weight;
                }
                if (this.costs != null && this.costs.includes((Object)obs)) {
                    this.weights *= -1.0;
                }
                this.weights += weight.doubleValue();
            }
        }

        @Override
        public void postProcess(String name) {
            double algVal = this.costs != null ? (this.weights != 0.0 ? this.sum / this.weights : 0.0) : this.sum;
            this.result.put(name, algVal);
            this.sum = 0.0;
            this.weights = 0.0;
        }
    }
}

